/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.tree;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.AccessorAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.MatchNode;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TreeContentMergeViewerContentProvider
implements IMergeViewerContentProvider {
    private final CompareConfiguration fCompareConfiguration;
    private final Comparison fComparison;

    public TreeContentMergeViewerContentProvider(CompareConfiguration cc, Comparison comparison) {
        this.fCompareConfiguration = cc;
        this.fComparison = comparison;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer v, Object o1, Object o2) {
    }

    public String getAncestorLabel(Object element) {
        return this.fCompareConfiguration.getAncestorLabel(element);
    }

    public Image getAncestorImage(Object element) {
        return this.fCompareConfiguration.getAncestorImage(element);
    }

    public Object getAncestorContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement ancestor = ((ICompareInput)element).getAncestor();
            if (ancestor instanceof AccessorAdapter) {
                return ((AccessorAdapter)ancestor).getTarget();
            }
            return ancestor;
        }
        return null;
    }

    public boolean showAncestor(Object element) {
        return element instanceof ICompareInput;
    }

    public String getLeftLabel(Object element) {
        return this.fCompareConfiguration.getLeftLabel(element);
    }

    public Image getLeftImage(Object element) {
        return this.fCompareConfiguration.getLeftImage(element);
    }

    public Object getLeftContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement left = ((ICompareInput)element).getLeft();
            if (left instanceof AccessorAdapter) {
                return ((AccessorAdapter)left).getTarget();
            }
            return left;
        }
        return null;
    }

    public boolean isLeftEditable(Object element) {
        boolean ret = false;
        if (element instanceof MatchNode) {
            ret = this.fCompareConfiguration.isLeftEditable();
        } else {
            Object left = this.getLeftContent(element);
            if (left instanceof IEditableContent) {
                ret = ((IEditableContent)left).isEditable();
            }
        }
        return ret;
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        EList matches = this.fComparison.getMatches();
        EObject leftEObject = null;
        for (Match match : matches) {
            leftEObject = match.getLeft();
            if (leftEObject != null) break;
        }
        if (leftEObject != null) {
            Resource eResource = leftEObject.eResource();
            ResourceSet resourceSet = eResource.getResourceSet();
            ResourceUtil.saveAllResources((ResourceSet)resourceSet, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        }
    }

    public String getRightLabel(Object element) {
        return this.fCompareConfiguration.getRightLabel(element);
    }

    public Image getRightImage(Object element) {
        return this.fCompareConfiguration.getRightImage(element);
    }

    public Object getRightContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement right = ((ICompareInput)element).getRight();
            if (right instanceof AccessorAdapter) {
                return ((AccessorAdapter)right).getTarget();
            }
            return right;
        }
        return null;
    }

    public boolean isRightEditable(Object element) {
        boolean editable = false;
        if (element instanceof MatchNode) {
            editable = this.fCompareConfiguration.isRightEditable();
        } else if (element instanceof ICompareInput) {
            IDiffContainer parent;
            ITypedElement right = ((ICompareInput)element).getRight();
            if (right == null && element instanceof IDiffElement && (parent = ((IDiffElement)element).getParent()) instanceof ICompareInput) {
                right = ((ICompareInput)parent).getRight();
            }
            if (right instanceof IEditableContent) {
                editable = ((IEditableContent)right).isEditable();
            }
        }
        return editable;
    }

    public void saveRightContent(Object element, byte[] bytes) {
        EList matches = this.fComparison.getMatches();
        EObject rightEObject = null;
        for (Match match : matches) {
            rightEObject = match.getRight();
            if (rightEObject != null) break;
        }
        if (rightEObject != null) {
            Resource eResource = rightEObject.eResource();
            ResourceSet resourceSet = eResource.getResourceSet();
            ResourceUtil.saveAllResources((ResourceSet)resourceSet, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        }
    }
}

