/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootIDMatchingStrategy
implements IResourceMatchingStrategy {
    @Override
    public List<MatchResource> matchResources(Iterable<? extends Resource> left, Iterable<? extends Resource> right, Iterable<? extends Resource> origin) {
        ArrayList mappings = Lists.newArrayList();
        ArrayList rightCopy = Lists.newArrayList(right);
        ArrayList originCopy = Lists.newArrayList(origin);
        for (Resource resource : left) {
            Resource matchingRight = this.findMatch(resource, rightCopy);
            Resource matchingOrigin = this.findMatch(resource, originCopy);
            if (matchingRight == null && matchingOrigin == null) continue;
            rightCopy.remove(matchingRight);
            originCopy.remove(matchingOrigin);
            mappings.add(this.createMatchResource(resource, matchingRight, matchingOrigin));
        }
        for (Resource resource : rightCopy) {
            Resource matchingOrigin = this.findMatch(resource, originCopy);
            originCopy.remove(matchingOrigin);
            if (matchingOrigin == null) continue;
            mappings.add(this.createMatchResource(null, resource, matchingOrigin));
        }
        return mappings;
    }

    protected Resource findMatch(Resource reference, Iterable<Resource> candidates) {
        Set<String> referenceIDs = this.getResourceIdentifiers(reference);
        if (referenceIDs.isEmpty()) {
            return null;
        }
        Resource match = null;
        Iterator<Resource> candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext() && match == null) {
            Resource candidate = candidateIterator.next();
            Set<String> candidateIDs = this.getResourceIdentifiers(candidate);
            if (candidateIDs.isEmpty() || Sets.intersection(candidateIDs, referenceIDs).isEmpty()) continue;
            match = candidate;
        }
        return match;
    }

    protected Set<String> getResourceIdentifiers(Resource resource) {
        HashSet identifiers = Sets.newHashSet();
        for (EObject root : resource.getContents()) {
            if (resource instanceof XMIResource) {
                identifiers.add(((XMIResource)resource).getID(root));
            }
            identifiers.add(EcoreUtil.getID((EObject)root));
        }
        return identifiers;
    }

    protected MatchResource createMatchResource(Resource left, Resource right, Resource origin) {
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && left.getURI() != null) {
            match.setLeftURI(left.getURI().toString());
        }
        if (right != null && right.getURI() != null) {
            match.setRightURI(right.getURI().toString());
        }
        if (origin != null && origin.getURI() != null) {
            match.setOriginURI(origin.getURI().toString());
        }
        return match;
    }
}

