/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.DeployedQvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.WorkspaceQvtModule;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationUtil {
    public static final String DEFAULT_RESULT_EXTENSION = "psm";

    private TransformationUtil() {
    }

    public static void getErrors(CompiledUnit unit, List<QvtMessage> errors, boolean concreteSyntaxOnly) {
        if (concreteSyntaxOnly && !"qvto".equals(unit.getURI().fileExtension())) {
            return;
        }
        errors.addAll(unit.getErrors());
        for (CompiledUnit imp : unit.getCompiledImports()) {
            TransformationUtil.getErrors(imp, errors, concreteSyntaxOnly);
        }
    }

    public static void getWarnings(CompiledUnit unit, List<QvtMessage> warnings, boolean concreteSyntaxOnly) {
        if (concreteSyntaxOnly && !"qvto".equals(unit.getURI().fileExtension())) {
            return;
        }
        warnings.addAll(unit.getWarnings());
        for (CompiledUnit imp : unit.getCompiledImports()) {
            TransformationUtil.getWarnings(imp, warnings, concreteSyntaxOnly);
        }
    }

    public static QvtModule getQvtModule(URI uriTransf) throws MdaException {
        if (uriTransf == null) {
            throw new MdaException(NLS.bind((String)Messages.TransformationUtil_InvalidUri, (Object)uriTransf));
        }
        IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)uriTransf);
        if (ifile != null && ifile.exists()) {
            return new WorkspaceQvtModule(ifile);
        }
        return new DeployedQvtModule(uriTransf);
    }

    public static String getTransformationFqn(QvtTransformation transformation) {
        if (transformation == null) {
            return null;
        }
        try {
            return transformation.getURI().toString();
        }
        catch (MdaException e) {
            return transformation.toString();
        }
    }

    public static boolean isRunnable(QvtTransformation transformation) throws MdaException {
        return transformation.hasEntryOperation() || transformation.isBlackbox();
    }
}

