/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.QvtNamesChecker;
import org.eclipse.m2m.internal.qvt.oml.project.QvtProjectUtil;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtCompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtNamespace;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtProject;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtModelException;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.NamesInScopeChecker;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.SourceDestinationChooser;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.INewQVTElementDestinationWizardDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewQvtModuleCreationPage
extends WizardPage
implements Listener {
    private IStatus fStatus = Status.OK_STATUS;
    private IPath fInitialContainerPath;
    private IFile fNewModuleFile;
    private INewQVTElementDestinationWizardDelegate fDestinationProvider;
    private boolean fWasEverShown = false;
    private Text fModuleNameField;
    private Text fContainerField;
    private Text fNameSpaceField;

    public NewQvtModuleCreationPage() {
        super("QVT module creation");
    }

    public NewQvtModuleCreationPage(INewQVTElementDestinationWizardDelegate destinationProvider) {
        this();
        if (destinationProvider == null) {
            throw new IllegalArgumentException();
        }
        this.fDestinationProvider = destinationProvider;
        this.fInitialContainerPath = destinationProvider.getSourceContainer().getFullPath();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = this.hasExternalDestinationProvider() ? 3 : 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label containerLabel = new Label(composite, 0);
        containerLabel.setText(Messages.NewQvtModuleCreationPage_sourceContainerFieldLabel);
        this.fContainerField = new Text(composite, 2048);
        this.fContainerField.addListener(24, (Listener)this);
        GridData containerData = new GridData(768);
        containerData.horizontalSpan = 2;
        this.fContainerField.setLayoutData((Object)containerData);
        if (!this.hasExternalDestinationProvider()) {
            Button browseSrcContainerBtn = new Button(composite, 0);
            browseSrcContainerBtn.setText(Messages.NewQvtModuleCreationPage_browseButtonLabel);
            browseSrcContainerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IContainer sourceContainer = SourceDestinationChooser.chooseSourceContainer(NewQvtModuleCreationPage.this.getShell(), null);
                    if (sourceContainer != null) {
                        NewQvtModuleCreationPage.this.fContainerField.setText(sourceContainer.getFullPath().toString());
                    }
                }
            });
        } else {
            this.fContainerField.setEnabled(false);
        }
        Label namespaceLabel = new Label(composite, 0);
        namespaceLabel.setText(Messages.NewQvtModuleCreationPage_namespaceFieldLabel);
        namespaceLabel.setLayoutData((Object)new GridData(256));
        this.fNameSpaceField = new Text(composite, 2048);
        this.fNameSpaceField.addListener(24, (Listener)this);
        this.fNameSpaceField.setLayoutData((Object)new GridData(768));
        final Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText(Messages.NewQvtModuleCreationPage_defaultNamespaceLabel);
        defaultLabel.setLayoutData((Object)new GridData(256));
        this.fNameSpaceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = NewQvtModuleCreationPage.this.fNameSpaceField.getText();
                if (text == null || text.length() == 0) {
                    defaultLabel.setVisible(true);
                } else {
                    defaultLabel.setVisible(false);
                }
            }
        });
        if (!this.hasExternalDestinationProvider()) {
            Button browseNamespaceBtn = new Button(composite, 0);
            browseNamespaceBtn.setText(Messages.NewQvtModuleCreationPage_browseButtonLabel);
            browseNamespaceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IQvtNamespace namespace = SourceDestinationChooser.chooseNamespaceFolder(NewQvtModuleCreationPage.this.getShell());
                    if (namespace != null) {
                        NewQvtModuleCreationPage.this.fNameSpaceField.setText(namespace.getQualifiedName());
                        try {
                            String srcPath = namespace.getQvtProject().getQvtSourceContainerPath().toString();
                            NewQvtModuleCreationPage.this.fContainerField.setText(srcPath);
                        }
                        catch (QvtModelException exc) {
                            QVTUIPlugin.log(exc);
                        }
                    }
                }
            });
        }
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.NewQvtModuleCreationPage_moduleNameFieldLabel);
        nameLabel.setLayoutData((Object)new GridData(256));
        this.fModuleNameField = new Text(composite, 2048);
        this.fModuleNameField.addListener(24, (Listener)this);
        GridData nameGridData = new GridData(256);
        nameGridData.horizontalSpan = 1;
        this.fModuleNameField.setLayoutData((Object)nameGridData);
        this.performInitialSettings();
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    protected void performInitialSettings() {
        if (this.hasExternalDestinationProvider() && this.fInitialContainerPath != null) {
            this.fContainerField.setText(this.fInitialContainerPath.toString());
        }
        IQvtElement initialContext = null;
        try {
            initialContext = this.findInitialQvtProjectScopeContext();
        }
        catch (Exception e) {
            QVTUIPlugin.log(e);
        }
        if (initialContext != null) {
            String initialContainer;
            String initialNamespace = this.computeInitialNamespace(initialContext);
            if (initialNamespace != null) {
                this.fNameSpaceField.setText(initialNamespace);
            }
            if ((initialContainer = this.computeInitialSourceContainer(initialContext)) != null) {
                this.fContainerField.setText(initialContainer);
            }
        }
        String resultName = this.performProposedNameCorrections(this.getNewModuleNameProposal());
        assert (resultName != null);
        if (resultName != null) {
            this.fModuleNameField.setText(resultName);
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 24) {
            this.validatePage();
        }
    }

    public final String getModuleName() {
        return this.getModuleNameValue();
    }

    protected String getModuleNameValue() {
        return this.fModuleNameField != null ? this.fModuleNameField.getText() : null;
    }

    protected String getNewModuleNameProposal() {
        return Messages.NewQvtModuleCreationPage_newModuleNameProposal;
    }

    protected final void validatePage() {
        IStatus[] result = this.doValidatePage();
        this.updateStatus(result);
    }

    protected final void updateStatus(IStatus[] result) {
        this.fStatus = Status.OK_STATUS;
        IStatus[] iStatusArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.getSeverity() > this.fStatus.getSeverity()) {
                this.fStatus = status;
            }
            ++n2;
        }
        if (!this.fStatus.isOK()) {
            int type = 0;
            switch (this.fStatus.getSeverity()) {
                case 4: {
                    type = 3;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 1: {
                    type = 1;
                }
            }
            this.setMessage(this.fStatus.getMessage(), type);
            this.setPageComplete(this.isValid());
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(true);
        }
    }

    protected IStatus[] doValidatePage() {
        return new IStatus[]{this.doValidateSourceContainer(), this.doValidateNamespace(), this.doValidateModuleName()};
    }

    protected IStatus doValidateModuleName() {
        IQvtProject qvtProject;
        IStatus status = QvtNamesChecker.validateQvtModuleIdentifier((String)this.getModuleNameValue());
        if (status.isOK() && (qvtProject = this.getTargetQvtProject()) != null && qvtProject.getProject().exists() && this.doValidateNamespace().isOK()) {
            String unitQualifiedName = this.getNewModuleQualifiedName();
            try {
                IQvtCompilationUnit existingCU = qvtProject.findCompilationUnit(unitQualifiedName);
                if (existingCU != null) {
                    String message = Messages.NewQvtModuleCreationPage_moduleAlreadyExists;
                    return QVTUIPlugin.createStatus(4, NLS.bind((String)message, (Object)unitQualifiedName));
                }
            }
            catch (QvtModelException e) {
                QVTUIPlugin.log(e);
            }
        }
        return status;
    }

    private IQvtProject getTargetQvtProject() {
        IProject project;
        if (!this.doValidateSourceContainer().isOK()) {
            return null;
        }
        IContainer srcContainer = this.getSourceContainer();
        if (srcContainer != null && (project = srcContainer.getProject()).exists()) {
            return QvtProjectUtil.getQvtProject((IProject)project);
        }
        return null;
    }

    protected String getNewModuleQualifiedName() {
        String unitQualifiedName = null;
        String nsValue = this.getNamespaceValue();
        unitQualifiedName = nsValue != null && nsValue.length() > 0 ? String.valueOf(this.getNamespaceValue()) + "." + this.getModuleNameValue() : this.getModuleNameValue();
        return unitQualifiedName;
    }

    protected boolean isValid() {
        return this.fStatus.getSeverity() <= 2;
    }

    public boolean isPageComplete() {
        return this.fWasEverShown && super.isPageComplete() && this.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.fWasEverShown) {
            this.fModuleNameField.forceFocus();
            this.fModuleNameField.selectAll();
            this.fWasEverShown = true;
        }
        if (this.fDestinationProvider != null) {
            this.updateDestinationFromProvider();
        }
        this.validatePage();
    }

    protected boolean hasExternalDestinationProvider() {
        return this.fDestinationProvider != null;
    }

    protected String computeInitialNamespace(IQvtElement context) {
        IQvtNamespace namespace = null;
        if (context != null) {
            int type = context.getElementType();
            if (type == 3) {
                IQvtCompilationUnit cu = (IQvtCompilationUnit)context;
                namespace = cu.getNamespace();
            } else if (type == 2) {
                namespace = (IQvtNamespace)context;
            } else if (type == 1) {
                try {
                    namespace = ((IQvtProject)context).getDefaultNamespace();
                }
                catch (QvtModelException e) {
                    QVTUIPlugin.log(e);
                }
            }
        }
        return namespace != null ? namespace.getQualifiedName() : null;
    }

    protected final String computeInitialSourceContainer(IQvtElement context) {
        if (this.hasExternalDestinationProvider()) {
            if (this.fInitialContainerPath == null) {
                return null;
            }
            return this.fInitialContainerPath.toString();
        }
        try {
            return context.getQvtProject().getQvtSourceContainerPath().toString();
        }
        catch (QvtModelException e) {
            QVTUIPlugin.log(e);
            return null;
        }
    }

    protected IQvtElement computeInitialQvtElement(IResource context) {
        if (!context.exists()) {
            return null;
        }
        IQvtProject qvtProject = QvtProjectUtil.getQvtProject((IProject)context.getProject());
        IQvtElement qvtElement = null;
        if (qvtProject != null) {
            try {
                qvtElement = qvtProject.findElement(context, false);
            }
            catch (QvtModelException e) {
                IStatus status = QVTUIPlugin.createStatus(4, "Failed to compute intial namespace", e);
                QVTUIPlugin.log(status);
            }
        }
        return qvtElement;
    }

    protected IQvtElement findInitialQvtProjectScopeContext() {
        IResource resource;
        IEditorPart editorPart;
        ISelection selection;
        IWorkbenchPartSite site;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return null;
        }
        IQvtElement context = null;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage.getActivePart() instanceof IViewPart && (site = activePage.getActivePart().getSite()).getSelectionProvider() != null && (selection = site.getSelectionProvider().getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object nextElement : structuredSelection) {
                IResource resource2;
                if (!(nextElement instanceof IAdaptable) || (resource2 = (IResource)((IAdaptable)nextElement).getAdapter(IResource.class)) == null || !QvtProjectUtil.isQvtProject((IProject)resource2.getProject()) || (context = this.computeInitialQvtElement(resource2)) == null) continue;
                return context;
            }
        }
        if ((editorPart = activePage.getActiveEditor()) != null && editorPart.getEditorInput() != null && (resource = (IResource)editorPart.getEditorInput().getAdapter(IResource.class)) != null && QvtProjectUtil.isQvtProject((IProject)resource.getProject())) {
            context = this.computeInitialQvtElement(resource);
        }
        if (context == null) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                IQvtProject qvtProject = QvtProjectUtil.getQvtProject((IProject)project);
                if (qvtProject != null) {
                    return qvtProject;
                }
                ++n2;
            }
        }
        return context;
    }

    protected String getSourceContainerValue() {
        return this.fContainerField != null ? this.fContainerField.getText() : null;
    }

    protected String getNamespaceValue() {
        return this.fNameSpaceField != null ? this.fNameSpaceField.getText() : null;
    }

    protected IStatus doValidateSourceContainer() {
        IContainer container;
        IStatus status = NewQvtModuleCreationPage.validateSourceContainerPath(this.getSourceContainerValue());
        if (status.isOK() && (container = this.getSourceContainer()) != null) {
            if (!this.hasExternalDestinationProvider() && !container.exists()) {
                String message = NLS.bind((String)Messages.NewQvtModuleCreationPage_sourceContainerDoesNotExist, (Object)container.getFullPath().toString());
                status = QVTUIPlugin.createStatus(4, message, null);
            }
            if (container.exists()) {
                IQvtProject qvtProject = QvtProjectUtil.getQvtProject((IProject)container.getProject());
                try {
                    IPath containerFullPath = container.getFullPath();
                    if (qvtProject == null || !containerFullPath.equals((Object)qvtProject.getQvtSourceContainerPath())) {
                        return QVTUIPlugin.createStatus(4, NLS.bind((String)Messages.NewQvtModuleCreationPage_pathIsNotQVTContainer, (Object)containerFullPath.toString()), null);
                    }
                }
                catch (QvtModelException e) {
                    QVTUIPlugin.log(e);
                }
            }
        }
        return status;
    }

    public IFile getNewModuleFileHandle() {
        IContainer container = this.getRootNamespaceContainer();
        IPath path = container.getFullPath().append(String.valueOf(this.getModuleNameValue()) + ".qvto");
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public IFile createNewFile(String contents, IProgressMonitor monitor) {
        IFile file = this.getNewModuleFileHandle();
        IContainer container = file.getParent();
        if (!container.exists() && container.getType() == 2) {
            CreateFolderOperation folder = new CreateFolderOperation((IFolder)container, null, "Create container");
            try {
                IProgressMonitor progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
                folder.execute(progressMonitor, null);
            }
            catch (ExecutionException e) {
                QVTUIPlugin.log(e);
            }
        }
        try {
            file.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
            this.fNewModuleFile = file;
        }
        catch (CoreException e) {
            QVTUIPlugin.log(e);
        }
        return this.fNewModuleFile;
    }

    public IFile getNewCreatedModuleFile() {
        return this.fNewModuleFile;
    }

    protected IStatus doValidateNamespace() {
        String namespace = this.getNamespaceValue();
        if (namespace == null || namespace.length() == 0) {
            return Status.OK_STATUS;
        }
        return QvtNamesChecker.validateNamespaceQualifiedIdentifier((String)namespace);
    }

    protected IContainer getSourceContainer() {
        String sourceContainerFullPath = this.getSourceContainerValue();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IStatus pathStatus = ws.validatePath(sourceContainerFullPath, 6);
        if (pathStatus.isOK()) {
            Path path = new Path(sourceContainerFullPath);
            if (path.segmentCount() == 1) {
                return ws.getRoot().getProject(path.segment(0));
            }
            if (path.segmentCount() > 1) {
                return ws.getRoot().getFolder((IPath)path);
            }
        }
        return null;
    }

    private void updateDestinationFromProvider() {
        if (this.fDestinationProvider != null) {
            String containerPathValue = this.fDestinationProvider.getSourceContainer().getFullPath().toString();
            this.fContainerField.setText(containerPathValue);
        }
    }

    private String performProposedNameCorrections(final String proposedName) {
        return new NamesInScopeChecker(){

            @Override
            protected void doDefine(String newName) {
            }

            @Override
            protected boolean isDefined(String newName) {
                block3: {
                    String unitQualifiedName;
                    IQvtProject qvtProject;
                    block4: {
                        qvtProject = NewQvtModuleCreationPage.this.getTargetQvtProject();
                        if (qvtProject == null || !qvtProject.getProject().exists()) break block3;
                        NewQvtModuleCreationPage.this.fModuleNameField.setText(newName);
                        unitQualifiedName = NewQvtModuleCreationPage.this.getNewModuleQualifiedName();
                        if (QvtNamesChecker.validateQvtModuleIdentifier((String)proposedName).isOK()) break block4;
                        return false;
                    }
                    try {
                        IQvtCompilationUnit existingCU = qvtProject.findCompilationUnit(unitQualifiedName);
                        return existingCU != null;
                    }
                    catch (QvtModelException e) {
                        QVTUIPlugin.log(e);
                    }
                }
                return false;
            }
        }.checkedDefineName(proposedName);
    }

    private IContainer getRootNamespaceContainer() {
        if (!this.doValidateSourceContainer().isOK()) {
            return null;
        }
        IContainer srcContainer = this.getSourceContainer();
        if (srcContainer == null) {
            return null;
        }
        String namespace = this.getNamespaceValue();
        if (namespace == null || namespace.length() == 0) {
            return srcContainer;
        }
        IStatus status = this.doValidateNamespace();
        if (!status.isOK()) {
            return null;
        }
        Path nsPath = new Path(namespace.replace('.', '/'));
        return srcContainer.getFolder((IPath)nsPath);
    }

    static IStatus validateSourceContainerPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return QVTUIPlugin.createStatus(4, Messages.NewQvtModuleCreationPage_sourceContainerPathMustBeSpecified, null);
        }
        return ResourcesPlugin.getWorkspace().validatePath(path, 6);
    }

    static void openInEditor(Shell shell, IFile file) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)file);
            shell.getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Messages.NewQVTTransformationWizard_OpenEditorError, (String)exception.getMessage());
        }
    }
}

