/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.samples.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.SampleProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.Bundle;

public class SampleProjectsCreationOperation
implements IRunnableWithProgress {
    private IProject myCreatedProject;
    private final SampleProject myProject;
    private final IOverwriteQuery myOverwriteQuery;
    private final IOverwriteQuery myProjectOverwriteQuery;
    private static final String SAMPLE_PROPERTIES = "sample.properties";

    public SampleProjectsCreationOperation(SampleProject project, Shell shell) {
        this.myOverwriteQuery = this.createOverwriteQuery(shell);
        this.myProjectOverwriteQuery = this.createProjectOverwriteQuery(shell);
        this.myProject = project;
    }

    public IProject getCreatedProject() {
        return this.myCreatedProject;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            try {
                IWorkspaceRunnable op = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor localMonitor) throws CoreException {
                        localMonitor.beginTask(Messages.SampleProjectsCreationOperation_creatingProjects, 4);
                        try {
                            SampleProjectsCreationOperation.this.myCreatedProject = SampleProjectsCreationOperation.this.importProject(SampleProjectsCreationOperation.this.myProject, (IProgressMonitor)new SubProgressMonitor(localMonitor, 4));
                            SampleProjectsCreationOperation.this.myCreatedProject.build(6, (IProgressMonitor)new SubProgressMonitor(localMonitor, 1));
                        }
                        catch (InterruptedException interruptedException) {
                            throw new OperationCanceledException();
                        }
                        catch (InvocationTargetException e) {
                            SampleProjectsCreationOperation.this.throwCoreException(e);
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(op, monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IOverwriteQuery createOverwriteQuery(Shell shell) {
        return new OverwriteQuery(shell){

            protected String[] getOptions() {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL};
            }

            protected String[] getReturnCodes() {
                return new String[]{"YES", "NO", "ALL", "CANCEL"};
            }
        };
    }

    protected IOverwriteQuery createProjectOverwriteQuery(Shell shell) {
        return new OverwriteQuery(shell){

            protected String[] getOptions() {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            }

            protected String[] getReturnCodes() {
                return new String[]{"YES", "NO", "CANCEL"};
            }
        };
    }

    private void throwCoreException(InvocationTargetException e) throws CoreException {
        Status status = new Status(4, "org.eclipse.m2m.qvt.oml.samples", 0, e.getMessage(), e.getCause());
        throw new CoreException((IStatus)status);
    }

    private IProject importProject(SampleProject sampleProject, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String path = sampleProject.getArchive();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(sampleProject.getName());
        if (project.exists()) {
            String overwrite = this.myProjectOverwriteQuery.queryOverwrite(project.getName());
            if ("YES".equals(overwrite) || "ALL".equals(overwrite)) {
                project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                project = root.getProject(sampleProject.getName());
            } else {
                if ("NO".equals(overwrite) || "NOALL".equals(overwrite)) {
                    return project;
                }
                throw new OperationCanceledException();
            }
        }
        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Platform.getBundle((String)sampleProject.getNamespace());
        ZipFile zipFile = this.getZipFileFromPluginDir(path, bundle);
        this.importFilesFromZip(zipFile, project.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.createSampleManifest(project, sampleProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IProjectDescription description = project.getDescription();
        String tempName = "temp" + System.currentTimeMillis();
        while (root.getProject(tempName).exists()) {
            tempName = String.valueOf(tempName) + System.currentTimeMillis();
        }
        description.setName(tempName);
        project.setDescription(description, null);
        description.setName(sampleProject.getName());
        project.setDescription(description, null);
        return project;
    }

    private IFile createSampleManifest(IProject project, SampleProject sampleProject, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(SAMPLE_PROPERTIES);
        if (!file.exists()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Properties properties = new Properties();
                this.createSampleManifestContent(sampleProject, properties);
                properties.store(out, "");
                out.flush();
                String contents = out.toString();
                out.close();
                ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
                file.create((InputStream)stream, true, monitor);
                stream.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    private void createSampleManifestContent(SampleProject sampleProject, Properties properties) {
        this.writeProperty(properties, "name", sampleProject.getName());
        this.writeProperty(properties, "projectName", sampleProject.getName());
        this.writeProperty(properties, "description", sampleProject.getDescription());
        this.writeProperty(properties, "helpHref", sampleProject.getHelpHref());
    }

    private void writeProperty(Properties properties, String name, String value) {
        if (value == null) {
            return;
        }
        properties.setProperty(name, value);
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath, Bundle bundle) throws CoreException {
        try {
            URL entry = FileLocator.find((Bundle)bundle, (IPath)new Path(pluginRelativePath), null);
            if (entry == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.SampleProjectsCreationOperation_NoEntry, (Object)pluginRelativePath, (Object)bundle));
            }
            return new ZipFile(FileLocator.toFileURL((URL)entry).getFile());
        }
        catch (Exception e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, "org.eclipse.m2m.qvt.oml.samples", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.myOverwriteQuery);
        op.run(monitor);
    }

    protected static abstract class OverwriteQuery
    implements IOverwriteQuery {
        private final Shell myShell;

        public OverwriteQuery(Shell shell) {
            this.myShell = shell;
        }

        public String queryOverwrite(String file) {
            String[] returnCodes = this.getReturnCodes();
            int returnVal = this.openDialog(file);
            return returnVal < 0 ? "CANCEL" : returnCodes[returnVal];
        }

        protected abstract String[] getOptions();

        protected abstract String[] getReturnCodes();

        protected int getDefaultIndex() {
            return 0;
        }

        private int openDialog(final String file) {
            final int[] result = new int[]{1};
            this.myShell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String title = Messages.SampleProjectsCreationOperation_overwrite_title;
                    String msg = NLS.bind((String)Messages.SampleProjectsCreationOperation_overwrite_message, (Object)file);
                    MessageDialog dialog = new MessageDialog(OverwriteQuery.this.myShell, title, null, msg, 3, OverwriteQuery.this.getOptions(), OverwriteQuery.this.getDefaultIndex());
                    result[0] = dialog.open();
                }
            });
            return result[0];
        }
    }
}

