/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.common.TypedModelsConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.DatumCaches;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.LoadingRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDatum;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDependencyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDependencyPaths;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationDependencyStep;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OperationRegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.OriginalContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.NameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.DirectedDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.graphs.DOTStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphMLStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TraceHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.CollectionClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionRole;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.OperationRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduleModel;
import org.eclipse.qvtd.pivot.qvtschedule.Utility;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.AbstractToGraphVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToGraphPartitionVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToGraphVisitor;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeLibraryHelper;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public abstract class AbstractScheduleManager
implements ScheduleManager {
    protected final @NonNull ScheduleModel scheduleModel;
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull Transformation transformation;
    protected final @NonNull ProblemHandler problemHandler;
    private @Nullable TraceHelper traceHelper = null;
    protected final  @Nullable CompilerOptions.StepOptions schedulerOptions;
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    private @Nullable DirectedDomainUsageAnalysis directedDomainUsageAnalysis = null;
    protected final @NonNull StandardLibraryHelper standardLibraryHelper;
    protected final @NonNull QVTruntimeLibraryHelper qvtruntimeLibraryHelper;
    private OperationDependencyAnalysis operationDependencyAnalysis = null;
    private @Nullable OriginalContentsAnalysis originalContentsAnalysis = null;
    private Map<@NonNull OperationDatum, @NonNull OperationRegion> operationDatum2operationRegion = new HashMap<OperationDatum, OperationRegion>();
    private final boolean doDotGraphs;
    private final boolean doYedGraphs;
    private @Nullable ConnectionManager connectionManager = null;

    protected AbstractScheduleManager(@NonNull ScheduleModel scheduleModel, @NonNull EnvironmentFactory environmentFactory, @NonNull Transformation transformation, @NonNull ProblemHandler problemHandler,  @Nullable CompilerOptions.StepOptions schedulerOptions, @Nullable RootDomainUsageAnalysis domainUsageAnalysis) {
        this.scheduleModel = scheduleModel;
        this.environmentFactory = environmentFactory;
        this.transformation = transformation;
        QVTbaseUtil.getPrimitiveTypedModel((Transformation)transformation);
        this.problemHandler = problemHandler;
        this.schedulerOptions = schedulerOptions;
        this.domainUsageAnalysis = domainUsageAnalysis != null ? domainUsageAnalysis : this.createDomainUsageAnalysis();
        this.standardLibraryHelper = new StandardLibraryHelper(environmentFactory.getStandardLibrary());
        this.qvtruntimeLibraryHelper = new QVTruntimeLibraryHelper();
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.doDotGraphs = true;
            this.doYedGraphs = true;
        } else if (schedulerOptions != null) {
            this.doDotGraphs = schedulerOptions.basicGet(CompilerChain.SCHEDULER_DOT_GRAPHS) == Boolean.TRUE;
            this.doYedGraphs = schedulerOptions.basicGet(CompilerChain.SCHEDULER_YED_GRAPHS) == Boolean.TRUE;
        } else {
            this.doDotGraphs = false;
            this.doYedGraphs = false;
        }
    }

    @Override
    public void addMappingRegion(@NonNull MappingRegion mappingRegion) {
        this.scheduleModel.getOwnedMappingRegions().add(mappingRegion);
    }

    @Override
    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    private void analyzeCallTree() {
        OriginalContentsAnalysis originalContentsAnalysis = this.getOriginalContentsAnalysis();
        HashMap<@NonNull Rule, @NonNull ArrayList<@NonNull E>> consumer2producers = new HashMap();
        ArrayList<@NonNull ClassDatum> middleClassDatums = new ArrayList<ClassDatum>();
        StringBuilder s = QVTm2QVTs.CALL_TREE.isActive() ? new StringBuilder() : null;
        for (ClassDatum classDatum : QVTscheduleUtil.getOwnedClassDatums((ScheduleModel)this.scheduleModel)) {
            TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
            DomainUsage usage = this.domainUsageAnalysis.getUsage((Element)typedModel);
            if (!usage.isMiddle()) continue;
            middleClassDatums.add(classDatum);
            Iterable<@NonNull RuleRegion> consumingRegions = originalContentsAnalysis.getDirectlyConsumingRegions(classDatum);
            Iterable<@NonNull RuleRegion> producingRegions = originalContentsAnalysis.getIndirectlyProducingRegions(classDatum);
            if (s != null) {
                s.append("middle: " + producingRegions + "\n");
            }
            for (RuleRegion consumingRegion : consumingRegions) {
                Rule consumer = QVTscheduleUtil.getReferredRule((RuleRegion)consumingRegion);
                ArrayList<@NonNull Rule> producers = (ArrayList<Rule>)consumer2producers.get(consumer);
                if (producers == null) {
                    producers = new ArrayList<Rule>();
                    consumer2producers.put(consumer, producers);
                }
                for (RuleRegion producingRegion : producingRegions) {
                    Rule producer = QVTscheduleUtil.getReferredRule((RuleRegion)producingRegion);
                    if (producers.contains(producer)) continue;
                    producers.add(producer);
                }
            }
        }
        if (s != null) {
            s.append("consumer2producers: " + consumer2producers);
            QVTm2QVTs.CALL_TREE.println(s.toString());
        }
    }

    @Override
    public @NonNull OperationRegion analyzeOperation(@NonNull OperationCallExp operationCallExp) {
        Operation operation = operationCallExp.getReferredOperation();
        LanguageExpression bodyExpression = operation.getBodyExpression();
        assert (bodyExpression != null);
        try {
            ExpressionInOCL specification = ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)this.environmentFactory).parseSpecification(bodyExpression);
            OperationDatum operationDatum = this.createOperationDatum(operationCallExp);
            OperationRegion operationRegion = this.operationDatum2operationRegion.get(operationDatum);
            if (operationRegion == null) {
                operationRegion = this.createOperationRegion(this, operationCallExp, specification, operationDatum);
                this.operationDatum2operationRegion.put(operationDatum, operationRegion);
                this.writeDebugGraphs((Graphable)operationRegion, null);
            }
            return operationRegion;
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public @NonNull OriginalContentsAnalysis analyzeOriginalContents() {
        OriginalContentsAnalysis contentsAnalysis = new OriginalContentsAnalysis(this);
        for (RuleRegion ruleRegion : this.gatherRuleRegions()) {
            contentsAnalysis.addRegion(ruleRegion);
            this.getRegionAnalysis((Region)ruleRegion);
        }
        this.getTransformationAnalysis().computeTraceClassInheritance();
        this.originalContentsAnalysis = contentsAnalysis;
        return contentsAnalysis;
    }

    @Override
    public void analyzeSourceModel(@NonNull ProblemHandler problemHandler) {
        this.getDirectedDomainUsageAnalysis().analyzeTransformation();
        AbstractTransformationAnalysis transformationAnalysis = this.getTransformationAnalysis();
        transformationAnalysis.analyzeSourceModel(problemHandler);
    }

    @Override
    public @NonNull AbstractTransformationAnalysis analyzeTransformation() {
        this.analyzeCallTree();
        return this.getTransformationAnalysis();
    }

    @Override
    public @Nullable ConnectionManager basicGetConnectionManager() {
        return this.connectionManager;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean computeIsPartial(@NonNull Node targetNode, @NonNull Property property) {
        ClassDatum elementClassDatum;
        ClassDatum targetClassDatum = QVTscheduleUtil.getClassDatum((Node)targetNode);
        DomainUsage domainUsage = this.getDomainUsage((Element)property);
        @NonNull Iterable typedModels = domainUsage.getTypedModels();
        TypedModel typedModel = Iterables.size((Iterable)typedModels) == 1 ? (TypedModel)typedModels.iterator().next() : QVTscheduleUtil.getReferredTypedModel((ClassDatum)targetClassDatum);
        Type type = PivotUtil.getType((TypedElement)property);
        CompleteClass completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(type);
        ClassDatum propertyClassDatum = this.getClassDatum(typedModel, completeClass);
        return !QVTscheduleUtil.conformsTo((ClassDatum)targetClassDatum, (ClassDatum)propertyClassDatum) && propertyClassDatum instanceof CollectionClassDatum && QVTscheduleUtil.conformsTo((ClassDatum)targetClassDatum, (ClassDatum)(elementClassDatum = QVTscheduleUtil.getElementalClassDatum((CollectionClassDatum)((CollectionClassDatum)propertyClassDatum))));
    }

    @Override
    public @NonNull ConnectionManager createConnectionManager(@NonNull ProblemHandler problemHandler, @NonNull LoadingRegionAnalysis loadingRegionAnalysis) {
        this.connectionManager = new ConnectionManager(problemHandler, this, loadingRegionAnalysis);
        return this.connectionManager;
    }

    protected @NonNull DatumCaches createDatumCaches() {
        return new DatumCaches(this);
    }

    protected abstract @NonNull DirectedDomainUsageAnalysis createDirectedDomainUsageAnalysis();

    protected abstract @NonNull RootDomainUsageAnalysis createDomainUsageAnalysis();

    protected @NonNull NameGenerator createNameGenerator() {
        return new NameGenerator();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull OperationDatum createOperationDatum(@NonNull OperationCallExp operationCallExp) {
        @NonNull List ownedArguments = ClassUtil.nullFree((List)operationCallExp.getOwnedArguments());
        @NonNull ClassDatum[] classDatums = new ClassDatum[1 + ownedArguments.size()];
        int i = 0;
        @NonNull OCLExpression source = operationCallExp.getOwnedSource();
        classDatums[i++] = this.getClassDatum((TypedElement)source);
        for (OCLExpression argument : ownedArguments) {
            classDatums[i++] = this.getClassDatum((TypedElement)argument);
        }
        String operationName = operationCallExp.getReferredOperation().getName();
        assert (operationName != null);
        return new OperationDatum(this, operationName, classDatums);
    }

    private @NonNull Node createOperationParameterNode(@NonNull OperationRegionHelper regionHelper, @NonNull Variable variable, @NonNull String name, @NonNull OCLExpression expression) {
        Class type = (Class)expression.getType();
        assert (type != null);
        TypedModel typedModel = this.getDomainUsage((Element)expression).getTypedModel((Element)expression);
        assert (typedModel != null);
        ClassDatum classDatum = this.getClassDatum(typedModel, type);
        Node parameterNode = regionHelper.createOperationParameterNode(Utility.getRequiredUtility((TypedElement)variable), name, classDatum);
        ((OperationRegion)regionHelper.getRegion()).addHeadNode(parameterNode);
        return parameterNode;
    }

    private @NonNull Node createOperationParameterNode(@NonNull OperationRegionHelper regionHelper, @NonNull Utility utility, @NonNull ClassDatum classDatum, @NonNull String name) {
        Node parameterNode = regionHelper.createOperationParameterNode(utility, name, classDatum);
        ((OperationRegion)regionHelper.getRegion()).addHeadNode(parameterNode);
        return parameterNode;
    }

    protected @NonNull OperationRegion createOperationRegion(@NonNull AbstractScheduleManager scheduleManager, @NonNull OperationCallExp operationCallExp, @NonNull ExpressionInOCL specification, @NonNull OperationDatum operationDatum) {
        HashMap<@NonNull Variable, @NonNull Node> parameter2node = new HashMap<Variable, Node>();
        String operationName = (String)ClassUtil.nonNullState((Object)operationDatum.toString());
        OperationRegion operationRegion = QVTscheduleFactory.eINSTANCE.createOperationRegion();
        scheduleManager.getScheduleModel().getOwnedOperationRegions().add(operationRegion);
        operationRegion.setReferredOperation((Operation)ClassUtil.nonNullState((Object)operationCallExp.getReferredOperation()));
        operationRegion.setName(operationName);
        OperationRegionHelper regionHelper = new OperationRegionHelper((ScheduleManager)scheduleManager, operationRegion);
        Variable selfVariable = specification.getOwnedContext();
        OCLExpression source = operationCallExp.getOwnedSource();
        assert (source != null);
        Node selfNode = this.createOperationParameterNode(regionHelper, selfVariable, (String)ClassUtil.nonNullState((Object)selfVariable.getName()), source);
        parameter2node.put(selfVariable, selfNode);
        Node dependencyNode = selfNode;
        Utility utility = Utility.getRequiredUtility((TypedElement)operationCallExp);
        Node resultNode = regionHelper.createStepNode(utility, "result", (CallExp)operationCallExp, dependencyNode);
        operationRegion.setResultNode(resultNode);
        regionHelper.createEqualsEdge(utility, dependencyNode, resultNode);
        List ownedParameters = specification.getOwnedParameters();
        List ownedArguments = operationCallExp.getOwnedArguments();
        int iSize = Math.min(ownedArguments.size(), ownedParameters.size());
        int i = 0;
        while (i < iSize) {
            Variable parameter = (Variable)ownedParameters.get(i);
            Node parameterNode = this.createOperationParameterNode(regionHelper, parameter, (String)ClassUtil.nonNullState((Object)parameter.getName()), (OCLExpression)ClassUtil.nonNullState((Object)((OCLExpression)ownedArguments.get(i))));
            parameter2node.put(parameter, parameterNode);
            ++i;
        }
        OperationDependencyAnalysis operationDependencyAnalysis = scheduleManager.getOperationDependencyAnalysis();
        OperationDependencyPaths paths = operationDependencyAnalysis.analyzeOperation(operationCallExp);
        Iterable<@NonNull List<@NonNull OperationDependencyStep>> hiddenPaths = paths.getHiddenPaths();
        Iterable<@NonNull List<@NonNull OperationDependencyStep>> returnPaths = paths.getReturnPaths();
        HashMap<@NonNull ClassDatum, @NonNull Node> classDatum2node = new HashMap<ClassDatum, Node>();
        for (List steps : Iterables.concat(returnPaths, hiddenPaths)) {
            Node dependencyNode2;
            if (steps.size() <= 0) continue;
            boolean isDirty = false;
            int i2 = 1;
            while (i2 < steps.size()) {
                OperationDependencyStep.PropertyStep step = (OperationDependencyStep.PropertyStep)steps.get(i2);
                Property asProperty = step.getProperty();
                if (this.getDirectedDomainUsageAnalysis().isDirty(asProperty)) {
                    isDirty = true;
                    break;
                }
                ++i2;
            }
            OperationDependencyStep.ClassStep classStep = (OperationDependencyStep.ClassStep)steps.get(0);
            DomainUsage stepUsage = classStep.getUsage();
            if ((!this.isOutput(stepUsage) || this.isInput(stepUsage)) && !isDirty) continue;
            Class stepType = ((OperationDependencyStep)steps.get(0)).getElementalType();
            TypedModel typedModel = stepUsage.getTypedModel(classStep.getElement());
            assert (typedModel != null);
            ClassDatum classDatum = scheduleManager.getClassDatum(typedModel, stepType);
            Class primaryClass = classDatum.getPrimaryClass();
            if (primaryClass instanceof DataType || primaryClass instanceof VoidType) continue;
            if (classStep.isParameter()) {
                dependencyNode2 = (Node)parameter2node.get(classStep.getElement());
                assert (dependencyNode2 != null);
            } else {
                dependencyNode2 = (Node)classDatum2node.get(classDatum);
                if (dependencyNode2 == null) {
                    assert (!"OclVoid".equals(stepType.getName()));
                    dependencyNode2 = this.createOperationParameterNode(regionHelper, Utility.NON_NULL_MATCHED, classDatum, "extra2_" + stepType.getName());
                    classDatum2node.put(classDatum, dependencyNode2);
                    operationRegion.addDependencyNode(dependencyNode2);
                }
            }
            int i3 = 1;
            while (i3 < steps.size()) {
                Node nextNode;
                OperationDependencyStep.PropertyStep step = (OperationDependencyStep.PropertyStep)steps.get(i3);
                Property property = step.getProperty();
                CallExp callExp = step.getCallExp();
                assert (property != null && callExp != null);
                if (primaryClass instanceof CollectionType) {
                    Property iterateProperty = scheduleManager.getIterateProperty((Type)primaryClass);
                    Type elementType = PivotUtil.getElementType((CollectionType)((CollectionType)primaryClass));
                    TypedModel typedModel2 = QVTscheduleUtil.getTypedModel((ClassDatum)classDatum);
                    ClassDatum elementClassDatum = scheduleManager.getClassDatum(typedModel2, (Class)elementType);
                    Node elementNode = regionHelper.createOperationElementNode(Utility.NON_NULL_MATCHED, operationName, elementClassDatum, dependencyNode2);
                    regionHelper.createNavigationEdge(Utility.NON_NULL_MATCHED, dependencyNode2, iterateProperty, elementNode, false);
                    dependencyNode2 = elementNode;
                }
                if (callExp instanceof NavigationCallExp) {
                    String name = CompilerUtil.recoverVariableName((NamedElement)callExp);
                    if (name == null) {
                        name = QVTscheduleUtil.getName((Nameable)PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)callExp)));
                    }
                    nextNode = regionHelper.createDataTypeNode(Utility.getRequiredUtility((TypedElement)callExp), name, dependencyNode2, (NavigationCallExp)callExp);
                } else {
                    nextNode = regionHelper.createDataTypeNode(Utility.getRequiredUtility((TypedElement)property), dependencyNode2, property);
                }
                regionHelper.createNavigationEdge(Utility.getRequiredUtility((TypedElement)property), dependencyNode2, property, nextNode, false);
                dependencyNode2 = nextNode;
                ++i3;
            }
        }
        operationRegion.toGraph((GraphStringBuilder)new DOTStringBuilder());
        operationRegion.toGraph((GraphStringBuilder)new GraphMLStringBuilder());
        return operationRegion;
    }

    protected @NonNull Property createProperty(@NonNull String name, @NonNull Type type, boolean isRequired) {
        Property property = PivotUtil.createProperty((String)name, (Type)type);
        property.setIsRequired(isRequired);
        return property;
    }

    protected abstract @NonNull AbstractTransformationAnalysis createTransformationAnalysis(@NonNull Transformation var1);

    @Override
    public @NonNull Iterable<@NonNull RuleRegion> gatherRuleRegions() {
        ArrayList<@NonNull RuleRegion> ruleRegions = new ArrayList<RuleRegion>();
        this.gatherRuleRegions(ruleRegions);
        Collections.sort(ruleRegions, NameUtil.NAMEABLE_COMPARATOR);
        return ruleRegions;
    }

    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        this.getTransformationAnalysis().gatherRuleRegions(ruleRegions);
    }

    @Override
    public @NonNull PropertyDatum getBasePropertyDatum(@NonNull PropertyDatum propertyDatum) {
        Property property = QVTscheduleUtil.getReferredProperty((PropertyDatum)propertyDatum);
        property = QVTscheduleUtil.getPrimaryProperty((Property)property);
        Class classType = QVTbaseUtil.getOwningClass((Property)property);
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)QVTscheduleUtil.getOwningClassDatum((PropertyDatum)propertyDatum));
        ClassDatum classDatum = this.getClassDatum(typedModel, classType);
        return this.getPropertyDatum(classDatum, property);
    }

    @Override
    public @NonNull ConnectionManager getConnectionManager() {
        return (ConnectionManager)ClassUtil.nonNullState((Object)this.connectionManager);
    }

    public abstract @NonNull ContainmentAnalysis getContainmentAnalysis();

    @Override
    public @NonNull DomainUsage getDomainUsage(@NonNull Element element) {
        if (element instanceof ClassDatum) {
            return this.getDomainUsage((Element)QVTscheduleUtil.getReferredTypedModel((ClassDatum)((ClassDatum)element)));
        }
        if (element instanceof TypedModel) {
            int netMask = 0;
            for (TypedModel typedModel : QVTbaseUtil.getAllTypedModels((TypedModel)((TypedModel)element))) {
                DomainUsage usage = this.domainUsageAnalysis.getUsage((Element)typedModel);
                netMask |= usage.getMask();
            }
            return this.domainUsageAnalysis.getConstantUsage(netMask);
        }
        DomainUsageAnalysis analysis = this.domainUsageAnalysis;
        Operation operation = PivotUtil.getContainingOperation((EObject)element);
        if (operation != null) {
            analysis = this.domainUsageAnalysis.getAnalysis(operation);
        }
        return (DomainUsage)ClassUtil.nonNullState((Object)analysis.getUsage(element));
    }

    public @NonNull DirectedDomainUsageAnalysis getDirectedDomainUsageAnalysis() {
        DirectedDomainUsageAnalysis directedDomainUsageAnalysis2 = this.directedDomainUsageAnalysis;
        if (directedDomainUsageAnalysis2 == null) {
            this.directedDomainUsageAnalysis = directedDomainUsageAnalysis2 = this.createDirectedDomainUsageAnalysis();
        }
        return directedDomainUsageAnalysis2;
    }

    @Override
    public @NonNull ScheduleManager getDirectedScheduleManager(@NonNull RootRegion rootRegion) {
        return this;
    }

    @Override
    public @NonNull RootDomainUsageAnalysis getDomainUsageAnalysis() {
        return this.domainUsageAnalysis;
    }

    @Override
    public @NonNull ClassDatum getElementalClassDatum(@NonNull ClassDatum classDatum) {
        Class type;
        Class elementType = type = classDatum.getPrimaryClass();
        while (elementType instanceof CollectionType) {
            elementType = ((CollectionType)elementType).getElementType();
        }
        if (elementType == null || elementType == type || !(elementType instanceof Class)) {
            return classDatum;
        }
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)classDatum);
        return this.getClassDatum(typedModel, elementType);
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    protected @NonNull URI getGraphURI(@NonNull Graphable graphable, @Nullable String suffix, @NonNull String fileExtension) {
        URI baseURI = this.scheduleModel.eResource().getURI().trimSegments(1).appendSegment("graphs").appendSegment("");
        String symbolName = graphable.getGraphName();
        if (suffix != null) {
            symbolName = String.valueOf(symbolName) + suffix;
        }
        symbolName = symbolName.replace("::", "!!").replace("?", "_").replace("*", "_").replace("|", "!");
        return URI.createURI((String)(String.valueOf(symbolName) + fileExtension)).resolve(baseURI);
    }

    public abstract @NonNull Property getIterateProperty(@NonNull Type var1);

    @Override
    public @NonNull ScheduleManager getMultipleScheduleManager() {
        return this;
    }

    public @NonNull OperationDependencyAnalysis getOperationDependencyAnalysis() {
        OperationDependencyAnalysis operationDependencyAnalysis2 = this.operationDependencyAnalysis;
        if (operationDependencyAnalysis2 == null) {
            this.operationDependencyAnalysis = operationDependencyAnalysis2 = new OperationDependencyAnalysis(this.getContainmentAnalysis(), this.getDomainUsageAnalysis());
        }
        return operationDependencyAnalysis2;
    }

    @Override
    public @NonNull OriginalContentsAnalysis getOriginalContentsAnalysis() {
        return (OriginalContentsAnalysis)ClassUtil.nonNullState((Object)this.originalContentsAnalysis);
    }

    @Override
    public @NonNull ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Override
    public @NonNull PropertyDatum getPropertyDatum(@NonNull NavigationEdge edge) {
        Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
        Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)edge);
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)sourceNode);
        return this.getPropertyDatum(classDatum, property);
    }

    @Override
    public @NonNull QVTruntimeLibraryHelper getQVTruntimeLibraryHelper() {
        return this.qvtruntimeLibraryHelper;
    }

    @Override
    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        AbstractTransformationAnalysis transformationAnalysis = this.getTransformationAnalysis();
        return transformationAnalysis.getRegionAnalysis(region);
    }

    @Override
    public @NonNull RootPartitionAnalysis getRootPartitionAnalysis(@NonNull RootRegion rootRegion) {
        AbstractTransformationAnalysis transformationAnalysis = this.getTransformationAnalysis(rootRegion);
        return transformationAnalysis.getRootPartitionAnalysis();
    }

    @Override
    public @NonNull RootRegion getRootRegion() {
        return this.getTransformationAnalysis().getRootRegion();
    }

    public @NonNull RuleAnalysis getRuleAnalysis(@NonNull Rule rule) {
        AbstractTransformationAnalysis transformationAnalysis = this.getTransformationAnalysis();
        return transformationAnalysis.getRuleAnalysis(rule);
    }

    @Override
    public @NonNull ScheduleModel getScheduleModel() {
        return this.scheduleModel;
    }

    @Override
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.environmentFactory.getStandardLibrary();
    }

    @Override
    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Iterable<@NonNull ClassDatum> getSuperClassDatums(@NonNull ClassDatum classDatum) {
        @NonNull List superClassDatums = QVTscheduleUtil.Internal.getSuperClassDatumsList((ClassDatum)classDatum);
        if (superClassDatums.isEmpty()) {
            DomainUsage domainUsage = this.getDomainUsage((Element)classDatum);
            for (CompleteClass completeClass : QVTscheduleUtil.getCompleteClasses((ClassDatum)classDatum)) {
                for (CompleteClass completeSuperClass : completeClass.getSuperCompleteClasses()) {
                    for (TypedModel typedModel : domainUsage.getTypedModels()) {
                        ClassDatum superClassDatum = this.getClassDatum(typedModel, completeSuperClass);
                        if (superClassDatums.contains(superClassDatum)) continue;
                        superClassDatums.add(superClassDatum);
                    }
                }
            }
        }
        return superClassDatums;
    }

    @Override
    public @NonNull TypedModel getTargetTypedModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull TraceHelper getTraceHelper() {
        TraceHelper traceHelper2 = this.traceHelper;
        if (traceHelper2 == null) {
            this.traceHelper = traceHelper2 = new TraceHelper(this.environmentFactory);
        }
        return traceHelper2;
    }

    @Override
    public @NonNull TypedModel getTraceTypedModel() {
        return this.domainUsageAnalysis.getTraceTypedModel();
    }

    @Override
    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis(@NonNull RootRegion rootRegion) {
        Transformation referredTransformation = QVTscheduleUtil.getReferredTransformation((RootRegion)rootRegion);
        assert (referredTransformation == this.transformation);
        return this.getTransformationAnalysis();
    }

    @Override
    public abstract @NonNull TypedModelsConfiguration getTypedModelsConfiguration();

    @Override
    public boolean isDirty(@NonNull Property property) {
        return this.getDirectedDomainUsageAnalysis().isDirty(property);
    }

    @Override
    public boolean isElementallyConformantSource(@NonNull NavigableEdge thatEdge, @NonNull NavigableEdge thisEdge) {
        ClassDatum thisElementalClassDatum;
        Node thatSource = thatEdge.getEdgeSource();
        Node thisSource = thisEdge.getEdgeSource();
        ClassDatum thatClassDatum = QVTscheduleUtil.getClassDatum((Node)thatSource);
        ClassDatum thisClassDatum = QVTscheduleUtil.getClassDatum((Node)thisSource);
        ClassDatum thatElementalClassDatum = this.getElementalClassDatum(thatClassDatum);
        if (QVTscheduleUtil.conformsTo((ClassDatum)thatElementalClassDatum, (ClassDatum)(thisElementalClassDatum = this.getElementalClassDatum(thisClassDatum)))) {
            return true;
        }
        if (thatSource.isRealized()) {
            return false;
        }
        return QVTscheduleUtil.conformsTo((ClassDatum)thisElementalClassDatum, (ClassDatum)thatElementalClassDatum);
    }

    @Override
    public boolean isInput(@NonNull DomainUsage domainUsage) {
        return this.getDirectedDomainUsageAnalysis().isInput(domainUsage);
    }

    @Override
    public boolean isInput(@NonNull TypedModel typedModel) {
        return this.getTypedModelsConfiguration().isInput(typedModel);
    }

    @Override
    public boolean isInputInRule(@NonNull Rule rule, @NonNull Element element) {
        return this.getDirectedDomainUsageAnalysis().isInputInRule(rule, element);
    }

    @Override
    public boolean isMiddle(@NonNull Node node) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)node);
        DomainUsage domainUsage = this.getDomainUsage((Element)classDatum);
        return domainUsage.isMiddle();
    }

    @Override
    public boolean isNoEarlyMerge() {
        CompilerOptions.StepOptions schedulerOptions2 = this.schedulerOptions;
        if (schedulerOptions2 == null) {
            return false;
        }
        return schedulerOptions2.basicGet(CompilerChain.SCHEDULER_NO_EARLY_MERGE) == Boolean.TRUE;
    }

    @Override
    public boolean isNoLateConsumerMerge() {
        CompilerOptions.StepOptions schedulerOptions2 = this.schedulerOptions;
        if (schedulerOptions2 == null) {
            return false;
        }
        return schedulerOptions2.basicGet(CompilerChain.SCHEDULER_NO_LATE_CONSUMER_MERGE) == Boolean.TRUE;
    }

    public boolean isKnown(@NonNull VariableDeclaration sourceVariable) {
        if (sourceVariable.eContainer() == null) {
            return false;
        }
        return !this.isOutputInRule(QVTbaseUtil.getContainingRule((EObject)sourceVariable), (Element)sourceVariable);
    }

    @Override
    public boolean isOutput(@NonNull DomainUsage domainUsage) {
        return this.getDirectedDomainUsageAnalysis().isOutput(domainUsage);
    }

    @Override
    public boolean isOutput(@NonNull TypedModel typedModel) {
        return this.getTypedModelsConfiguration().isOutput(typedModel);
    }

    @Override
    public boolean isOutputInRule(@NonNull Rule rule, @NonNull Element element) {
        return this.getDirectedDomainUsageAnalysis().isOutputInRule(rule, element);
    }

    @Override
    public void setRootRegion(@NonNull MappingRegion mappingRegion, @Nullable RootRegion rootRegion) {
        mappingRegion.setRootRegion(rootRegion);
    }

    @Override
    public void throwCompilerChainExceptionForErrors() throws CompilerChainException {
        this.problemHandler.throwCompilerChainExceptionForErrors();
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        s.append("{");
        for (TypedModel typedModel : QVTbaseUtil.getModelParameters((Transformation)this.transformation)) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(typedModel.getName());
            isFirst = false;
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public void writeDebugGraphs(@NonNull String context, @NonNull RootRegion rootRegion, boolean doNodesGraph, boolean doRegionGraph, boolean doCallGraph) {
        if (this.doDotGraphs || this.doYedGraphs) {
            if (doNodesGraph) {
                this.writeDebugGraphs((Graphable)rootRegion, context);
            }
            if (doRegionGraph) {
                String suffix = "-r-" + context;
                this.writeRegionDOTfile((Graphable)rootRegion, suffix);
                this.writeRegionGraphMLfile((Graphable)rootRegion, suffix);
            }
        }
    }

    @Override
    public void writeDebugGraphs(@NonNull Graphable graphable, @Nullable String context) {
        if (this.doDotGraphs || this.doYedGraphs) {
            String suffix = context != null ? "-" + context : null;
            this.writeDOTfile(graphable, suffix);
            this.writeGraphMLfile(graphable, suffix);
        }
    }

    public void writeDOTfile(@NonNull Graphable graphable, @Nullable String suffix) {
        if (this.doDotGraphs) {
            URI dotURI = this.getGraphURI(graphable, suffix, ".dot");
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                try {
                    AbstractToGraphVisitor visitor = ToGraphPartitionVisitor.createVisitor((GraphStringBuilder)new DOTStringBuilder(), (boolean)true);
                    visitor.visit(graphable);
                    outputStream.write(visitor.close().getBytes());
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException e) {
                QVTruntimeUtil.errPrintln((String)("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage()));
            }
        }
    }

    public void writeGraphMLfile(@NonNull Graphable graphable, @Nullable String suffix) {
        if (this.doYedGraphs) {
            URI dotURI = this.getGraphURI(graphable, suffix, ".graphml");
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                try {
                    AbstractToGraphVisitor visitor = ToGraphPartitionVisitor.createVisitor((GraphStringBuilder)new GraphMLStringBuilder(), (boolean)true);
                    visitor.visit(graphable);
                    outputStream.write(visitor.close().getBytes());
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException e) {
                QVTruntimeUtil.errPrintln((String)("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage()));
            }
        }
    }

    public void writeRegionDOTfile(@NonNull Graphable region, @NonNull String suffix) {
        if (this.doDotGraphs) {
            URI dotURI = this.getGraphURI(region, suffix, ".dot");
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                try {
                    AbstractToGraphVisitor visitor = ToGraphPartitionVisitor.createVisitor((GraphStringBuilder)new DOTStringBuilder(), (boolean)false);
                    visitor.visit(region);
                    outputStream.write(visitor.close().getBytes());
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException e) {
                QVTruntimeUtil.errPrintln((String)("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage()));
            }
            for (Region nestedRegion : QVTscheduleUtil.getActiveRegions((RootRegion)((RootRegion)region))) {
                if (!(nestedRegion instanceof RootRegion)) continue;
                this.writeRegionDOTfile((Graphable)nestedRegion, suffix);
            }
        }
    }

    public void writeRegionGraphMLfile(@NonNull Graphable region, @NonNull String suffix) {
        if (this.doYedGraphs) {
            URI dotURI = this.getGraphURI(region, suffix, ".graphml");
            try {
                OutputStream outputStream = this.environmentFactory.getResourceSet().getURIConverter().createOutputStream(dotURI);
                try {
                    AbstractToGraphVisitor visitor = ToGraphPartitionVisitor.createVisitor((GraphStringBuilder)new GraphMLStringBuilder(), (boolean)false);
                    visitor.visit(region);
                    outputStream.write(visitor.close().getBytes());
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (IOException e) {
                QVTruntimeUtil.errPrintln((String)("Failed to generate '" + dotURI + "' : " + e.getLocalizedMessage()));
            }
            for (Region nestedRegion : QVTscheduleUtil.getActiveRegions((RootRegion)((RootRegion)region))) {
                if (!(nestedRegion instanceof RootRegion)) continue;
                this.writeRegionGraphMLfile((Graphable)nestedRegion, suffix);
            }
        }
    }

    protected class ToGraphConnectableVisitor
    extends ToGraphVisitor {
        protected ToGraphConnectableVisitor(GraphStringBuilder context) {
            super(context);
        }

        public @Nullable String visitEdgeConnection(@NonNull EdgeConnection edgeConnection) {
            ConnectionManager connectionManager = AbstractScheduleManager.this.connectionManager;
            assert (connectionManager != null);
            if (edgeConnection.isEdge2Edge()) {
                NavigableEdge sourceEdge = (NavigableEdge)QVTscheduleUtil.getSourceEnds((EdgeConnection)edgeConnection).iterator().next();
                NavigableEdge targetEdge = (NavigableEdge)edgeConnection.getTargetEdges().iterator().next();
                this.appendEdge((GraphStringBuilder.GraphNode)sourceEdge.getEdgeTarget(), (GraphStringBuilder.GraphEdge)edgeConnection, (GraphStringBuilder.GraphNode)targetEdge.getEdgeTarget());
            } else {
                this.appendNode((GraphStringBuilder.GraphNode)edgeConnection);
                for (NavigableEdge source : QVTscheduleUtil.getSourceEnds((EdgeConnection)edgeConnection)) {
                    this.appendEdge((GraphStringBuilder.GraphNode)source.getEdgeTarget(), (GraphStringBuilder.GraphEdge)edgeConnection, (GraphStringBuilder.GraphNode)edgeConnection);
                }
                for (NavigableEdge target : edgeConnection.getTargetEdges()) {
                    ConnectionRole role = edgeConnection.getTargetRole((ConnectionEnd)target);
                    assert (role != null);
                    this.appendEdge((GraphStringBuilder.GraphNode)edgeConnection, (GraphStringBuilder.GraphEdge)role, (GraphStringBuilder.GraphNode)target.getEdgeTarget());
                }
            }
            return null;
        }

        public @Nullable String visitNodeConnection(@NonNull NodeConnection nodeConnection) {
            ConnectionManager connectionManager = AbstractScheduleManager.this.connectionManager;
            assert (connectionManager != null);
            if (nodeConnection.isNode2Node()) {
                Node sourceNode = (Node)QVTscheduleUtil.getSourceEnds((NodeConnection)nodeConnection).iterator().next();
                Node targetNode = (Node)nodeConnection.getTargetNodes().iterator().next();
                this.appendEdge((GraphStringBuilder.GraphNode)sourceNode, (GraphStringBuilder.GraphEdge)nodeConnection, (GraphStringBuilder.GraphNode)targetNode);
            } else {
                this.appendNode((GraphStringBuilder.GraphNode)nodeConnection);
                for (Node source : QVTscheduleUtil.getSourceEnds((NodeConnection)nodeConnection)) {
                    this.appendEdge((GraphStringBuilder.GraphNode)source, (GraphStringBuilder.GraphEdge)nodeConnection, (GraphStringBuilder.GraphNode)nodeConnection);
                }
                for (Node target : nodeConnection.getTargetNodes()) {
                    ConnectionRole role = nodeConnection.getTargetRole((ConnectionEnd)target);
                    assert (role != null);
                    this.appendEdge((GraphStringBuilder.GraphNode)nodeConnection, (GraphStringBuilder.GraphEdge)role, (GraphStringBuilder.GraphNode)target);
                }
            }
            return null;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable String visitPartition(@NonNull Partition partition) {
            ((GraphStringBuilder)this.context).setLabel(partition.getName());
            ((GraphStringBuilder)this.context).pushCluster();
            @NonNull ArrayList nodesList = Lists.newArrayList((Iterable)partition.getPartialNodes());
            Collections.sort(nodesList, NameUtil.TO_STRING_COMPARATOR);
            for (Node node : nodesList) {
                node.accept((Visitor)this);
            }
            @NonNull ArrayList edgesList = Lists.newArrayList((Iterable)partition.getPartialEdges());
            Collections.sort(edgesList, NameUtil.TO_STRING_COMPARATOR);
            for (Edge edge : edgesList) {
                edge.accept((Visitor)this);
            }
            ((GraphStringBuilder)this.context).popCluster();
            return null;
        }
    }
}

