/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.oclany.OclElementOclContainerProperty;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.AbstractMapping;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeArea;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeDomain;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTuneUpVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeDomainUsageAnalysis;

public class QVTiTransformationAnalysis {
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    private final @NonNull QVTimperativeDomainUsageAnalysis domainAnalysis;
    private final @NonNull Set<@NonNull Class> allInstancesClasses = new HashSet<Class>();
    private final @NonNull Map<@NonNull Property, @NonNull Integer> property2cacheIndex = new HashMap<Property, Integer>();
    private final @NonNull Map<Property, Integer> sourceProperty2cacheIndex = new HashMap<Property, Integer>();
    private final @NonNull Map<NavigationAssignment, Integer> navigationAssignment2cacheIndex = new HashMap<NavigationAssignment, Integer>();
    private final @NonNull Map<OppositePropertyCallExp, Integer> oppositePropertyCallExp2cacheIndex = new HashMap<OppositePropertyCallExp, Integer>();
    private final @NonNull Map<Operation, Set<NavigationCallExp>> operation2property = new HashMap<Operation, Set<NavigationCallExp>>();
    private final @NonNull Map<Mapping, Set<NavigationCallExp>> mapping2property = new HashMap<Mapping, Set<NavigationCallExp>>();
    private final @NonNull Map<Mapping, Set<PropertyAssignment>> mapping2propertyAssignments = new HashMap<Mapping, Set<PropertyAssignment>>();
    private final @NonNull Set<Mapping> hazardousMappings = new HashSet<Mapping>();
    private final @NonNull Set<Property> hazardousProperties = new HashSet<Property>();
    private final @NonNull Map<Property, Set<PropertyAssignment>> property2propertyAssignments = new HashMap<Property, Set<PropertyAssignment>>();
    private final @NonNull Map<Type, List<Type>> parentClass2childClasses = new HashMap<Type, List<Type>>();

    public QVTiTransformationAnalysis(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.domainAnalysis = new QVTimperativeDomainUsageAnalysis((EnvironmentFactory)environmentFactory);
    }

    private void addAllInstancesClass(@NonNull OCLExpression asExpression) {
        Type asType = asExpression.getTypeValue();
        if (asType == null) {
            asType = asExpression.getType();
        }
        if (asType instanceof Class) {
            assert (!(asType instanceof PrimitiveType));
            assert (!(asType instanceof CollectionType));
            this.allInstancesClasses.add((Class)asType);
        }
    }

    protected @NonNull Integer allocateCacheIndex(@Nullable OCLExpression sourceExpression, @NonNull Property navigableProperty) {
        Integer cacheIndex = this.property2cacheIndex.get(navigableProperty);
        if (cacheIndex == null) {
            DomainUsage sourceUsage;
            Integer size = this.property2cacheIndex.size();
            this.property2cacheIndex.put(navigableProperty, size);
            if (sourceExpression != null && (sourceUsage = this.domainAnalysis.basicGetUsage((Element)sourceExpression)) != null && sourceUsage.isInput()) {
                this.sourceProperty2cacheIndex.put(navigableProperty, size);
            }
            cacheIndex = size;
        }
        return cacheIndex;
    }

    private @NonNull Set<NavigationCallExp> analyzeMappingPropertyAccesses(@NonNull Mapping mapping) {
        Set<NavigationCallExp> accessedProperties = this.mapping2property.get(mapping);
        if (accessedProperties != null) {
            return accessedProperties;
        }
        accessedProperties = new HashSet<NavigationCallExp>();
        this.mapping2property.put(mapping, accessedProperties);
        this.analyzeTree(accessedProperties, (TreeIterator<EObject>)mapping.eAllContents());
        return accessedProperties;
    }

    private @NonNull Set<PropertyAssignment> analyzeMappingPropertyAssignments(@NonNull Mapping mapping) {
        Set<PropertyAssignment> assignedProperties = this.mapping2propertyAssignments.get(mapping);
        if (assignedProperties == null) {
            assignedProperties = new HashSet<PropertyAssignment>();
            this.mapping2propertyAssignments.put(mapping, assignedProperties);
        }
        TreeIterator treeIterator = mapping.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof PropertyAssignment)) continue;
            assignedProperties.add((PropertyAssignment)eObject);
        }
        return assignedProperties;
    }

    private @NonNull Set<NavigationCallExp> analyzeOperation(@NonNull Operation operation) {
        Set<NavigationCallExp> operationProperties = this.operation2property.get(operation);
        if (operationProperties != null) {
            return operationProperties;
        }
        operationProperties = new HashSet<NavigationCallExp>();
        this.operation2property.put(operation, operationProperties);
        this.analyzeTree(operationProperties, (TreeIterator<EObject>)operation.eAllContents());
        return operationProperties;
    }

    private void analyzeProperties() {
        Set<Mapping> hazardousMappings = this.getHazardousMappings();
        for (Map.Entry<Mapping, Set<NavigationCallExp>> entry : this.getMapping2Property().entrySet()) {
            Mapping mapping = entry.getKey();
            if (!hazardousMappings.contains(mapping)) continue;
            for (NavigationCallExp hazardousPropertyCallExp : entry.getValue()) {
                Property hazardousProperty = PivotUtil.getReferredProperty((NavigationCallExp)hazardousPropertyCallExp);
                this.hazardousProperties.add(hazardousProperty);
                this.hazardousProperties.add(hazardousProperty.getOpposite());
            }
        }
        for (Set set : this.mapping2propertyAssignments.values()) {
            for (PropertyAssignment propertyAssignment : set) {
                Property property = propertyAssignment.getTargetProperty();
                Set<PropertyAssignment> assignments = this.property2propertyAssignments.get(property);
                if (assignments == null) {
                    assignments = new HashSet<PropertyAssignment>();
                    this.property2propertyAssignments.put(property, assignments);
                }
                assignments.add(propertyAssignment);
            }
        }
    }

    protected void analyzeTree(@NonNull Set<NavigationCallExp> properties, TreeIterator<EObject> treeIterator) {
        while (treeIterator.hasNext()) {
            Property referredProperty;
            OppositePropertyCallExp asOppositePropertyCallExp;
            Property referredOppositeProperty;
            EObject eObject = (EObject)treeIterator.next();
            if (eObject instanceof OperationCallExp) {
                Operation referredOperation = ((OperationCallExp)eObject).getReferredOperation();
                if (referredOperation == null) continue;
                properties.addAll(this.analyzeOperation(referredOperation));
                continue;
            }
            if (eObject instanceof PropertyCallExp) {
                PropertyCallExp asPropertyCallExp = (PropertyCallExp)eObject;
                Property referredProperty2 = asPropertyCallExp.getReferredProperty();
                if (referredProperty2 == null) continue;
                LibraryFeature implementation = referredProperty2.getImplementation();
                if (implementation instanceof OclElementOclContainerProperty) {
                    Type childType = asPropertyCallExp.getOwnedSource().getType();
                    Type parentType = asPropertyCallExp.getType();
                    List<Type> childClasses = this.parentClass2childClasses.get(parentType);
                    if (childClasses == null) {
                        childClasses = new ArrayList<Type>();
                        this.parentClass2childClasses.put(parentType, childClasses);
                    }
                    if (childClasses.contains(childType)) continue;
                    childClasses.add(childType);
                    continue;
                }
                properties.add((NavigationCallExp)asPropertyCallExp);
                continue;
            }
            if (!(eObject instanceof OppositePropertyCallExp) || (referredOppositeProperty = (asOppositePropertyCallExp = (OppositePropertyCallExp)eObject).getReferredProperty()) == null || (referredProperty = referredOppositeProperty.getOpposite()) == null) continue;
            properties.add((NavigationCallExp)asOppositePropertyCallExp);
        }
    }

    public void analyzeTransformation(@NonNull Transformation transformation) {
        this.domainAnalysis.analyzeTransformation(transformation);
        transformation.accept((Visitor)QVTiTuneUpVisitor.INSTANCE);
        Class oclElementType = this.environmentFactory.getStandardLibrary().getOclElementType();
        Class modelType = this.environmentFactory.getStandardLibrary().getLibraryType("Model");
        OperationId allInstancesOperationId = oclElementType.getTypeId().getOperationId(0, "allInstances", IdManager.getParametersId((TypeId[])new TypeId[0]));
        OperationId objectsOfKindOperationId = modelType.getTypeId().getOperationId(1, "objectsOfKind", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        OperationId objectsOfTypeOperationId = modelType.getTypeId().getOperationId(1, "objectsOfType", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        ArrayList<PropertyAssignment> propertyAssignments = new ArrayList<PropertyAssignment>();
        TreeIterator tit = transformation.eAllContents();
        block0: while (tit.hasNext()) {
            OCLExpression argument;
            OperationCallExp operationCallExp;
            Operation referredOperation;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Mapping) {
                Mapping mapping = (Mapping)eObject;
                this.analyzeMappingPropertyAccesses(mapping);
                this.analyzeMappingPropertyAssignments(mapping);
                if (mapping.getCheckedProperties().size() > 0) {
                    this.hazardousMappings.add(mapping);
                    continue;
                }
                for (Domain domain : mapping.getDomain()) {
                    ImperativeDomain imperativeDomain;
                    if (!(domain instanceof ImperativeDomain) || (imperativeDomain = (ImperativeDomain)domain).getCheckedProperties().size() <= 0) continue;
                    this.hazardousMappings.add(mapping);
                    continue block0;
                }
                continue;
            }
            if (eObject instanceof MappingCallBinding) {
                MappingCallBinding mappingCallBinding = (MappingCallBinding)eObject;
                if (!mappingCallBinding.isIsPolled()) continue;
                Mapping mapping = mappingCallBinding.getMappingCall().getReferredMapping();
                this.hazardousMappings.add(mapping);
                continue;
            }
            if (eObject instanceof OppositePropertyCallExp) {
                OppositePropertyCallExp oppositePropertyCallExp = (OppositePropertyCallExp)eObject;
                Property navigableProperty = oppositePropertyCallExp.getReferredProperty();
                if (navigableProperty == null || navigableProperty.isIsComposite()) continue;
                int cacheIndex = this.allocateCacheIndex(oppositePropertyCallExp.getOwnedSource(), navigableProperty);
                this.oppositePropertyCallExp2cacheIndex.put(oppositePropertyCallExp, cacheIndex);
                continue;
            }
            if (eObject instanceof PropertyAssignment) {
                propertyAssignments.add((PropertyAssignment)eObject);
                continue;
            }
            if (!(eObject instanceof OperationCallExp) || (referredOperation = (operationCallExp = (OperationCallExp)eObject).getReferredOperation()) == null) continue;
            OperationId operationId = referredOperation.getOperationId();
            if (operationId == allInstancesOperationId) {
                OCLExpression source = operationCallExp.getOwnedSource();
                if (source == null) continue;
                this.addAllInstancesClass(source);
                continue;
            }
            if (operationId != objectsOfKindOperationId && operationId != objectsOfTypeOperationId || (argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0)) == null) continue;
            this.addAllInstancesClass(argument);
        }
        for (PropertyAssignment propertyAssignment : propertyAssignments) {
            Integer cacheIndex;
            Property navigableProperty = propertyAssignment.getTargetProperty();
            if (navigableProperty == null || (cacheIndex = this.property2cacheIndex.get(navigableProperty)) == null) continue;
            this.navigationAssignment2cacheIndex.put((NavigationAssignment)propertyAssignment, cacheIndex);
        }
        this.analyzeProperties();
    }

    public @NonNull Set<@NonNull Class> getAllInstancesClasses() {
        return this.allInstancesClasses;
    }

    public @Nullable Integer getCacheIndex(@NonNull OppositePropertyCallExp oppositePropertyCallExp) {
        return this.oppositePropertyCallExp2cacheIndex.get(oppositePropertyCallExp);
    }

    public @Nullable Integer getCacheIndex(@NonNull NavigationAssignment navigationAssignment) {
        return this.navigationAssignment2cacheIndex.get(navigationAssignment);
    }

    public int getCacheIndexes() {
        return this.property2cacheIndex.size();
    }

    public @NonNull Map<@NonNull Property, @NonNull Integer> getCaches() {
        return this.property2cacheIndex;
    }

    public @NonNull QVTimperativeDomainUsageAnalysis getDomainUsageAnalysis() {
        return this.domainAnalysis;
    }

    public @NonNull Set<Mapping> getHazardousMappings() {
        return this.hazardousMappings;
    }

    public @NonNull Map<@NonNull Class, @Nullable List<@NonNull Class>> getInstancesClassAnalysis(@NonNull Iterable<@NonNull Class> instanceClasses) {
        HashMap<@NonNull Class, @Nullable List<@NonNull Class>> instancesClassAnalysis = new HashMap<Class, List<Class>>();
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Class instanceClass : instanceClasses) {
            CompleteClassInternal completeInstanceClass = metamodelManager.getCompleteClass((Type)instanceClass);
            instancesClassAnalysis.put(completeInstanceClass.getPrimaryClass(), null);
        }
        for (Class instanceClass : instancesClassAnalysis.keySet()) {
            ArrayList<Class> superInstanceClasses = new ArrayList<Class>();
            superInstanceClasses.add(instanceClass);
            CompleteClassInternal completeClass = metamodelManager.getCompleteClass((Type)instanceClass);
            for (CompleteClass superCompleteClass : completeClass.getProperSuperCompleteClasses()) {
                Class superClass = superCompleteClass.getPrimaryClass();
                if (instancesClassAnalysis.containsKey(superClass)) {
                    superInstanceClasses.add(superClass);
                }
                instancesClassAnalysis.put(instanceClass, superInstanceClasses);
            }
        }
        return instancesClassAnalysis;
    }

    public @NonNull Map<Mapping, Set<NavigationCallExp>> getMapping2Property() {
        return this.mapping2property;
    }

    public @NonNull Map<Mapping, Set<PropertyAssignment>> getMapping2PropertyAssignments() {
        return this.mapping2propertyAssignments;
    }

    public @NonNull MetamodelManagerInternal getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull Map<Property, Integer> getSourceCaches() {
        return this.sourceProperty2cacheIndex;
    }

    public boolean hasHazardousRead(@NonNull MappingCall mappingCall) {
        for (MappingCallBinding callBinding : mappingCall.getBinding()) {
            if (!callBinding.isIsPolled()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHazardousWrite(@NonNull MappingCall mappingCall) {
        Mapping mapping = mappingCall.getReferredMapping();
        Set<PropertyAssignment> propertyAssignments = this.mapping2propertyAssignments.get(mapping);
        if (propertyAssignments == null) {
            return false;
        }
        for (PropertyAssignment propertyAssignment : propertyAssignments) {
            Property assignedProperty = propertyAssignment.getTargetProperty();
            if (this.hazardousProperties.contains(assignedProperty)) {
                return true;
            }
            if (!this.hazardousProperties.contains(assignedProperty.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public boolean isAssigned(@NonNull Property targetProperty, @NonNull DomainUsage domainUsage) {
        Set<PropertyAssignment> propertyAssignments = this.property2propertyAssignments.get(targetProperty);
        if (propertyAssignments == null) {
            return false;
        }
        for (PropertyAssignment propertyAssignment : propertyAssignments) {
            OCLExpression slotExpression = propertyAssignment.getSlotExpression();
            DomainUsage slotUsage = this.domainAnalysis.basicGetUsage((Element)slotExpression);
            if (domainUsage != slotUsage) continue;
            return true;
        }
        return false;
    }

    public boolean isHazardous(@NonNull Property targetProperty) {
        if (this.hazardousProperties.contains(targetProperty)) {
            return true;
        }
        if (!targetProperty.isIsComposite()) {
            return false;
        }
        StandardLibraryInternal standardLibrary = this.environmentFactory.getStandardLibrary();
        Class parentType = targetProperty.getOwningClass();
        Type childType = targetProperty.getType();
        assert (childType != null);
        for (Map.Entry<Type, List<Type>> entry : this.parentClass2childClasses.entrySet()) {
            Type entryType = entry.getKey();
            assert (entryType != null);
            if (!parentType.conformsTo((StandardLibrary)standardLibrary, entryType)) continue;
            for (Type type : entry.getValue()) {
                if (!type.conformsTo((StandardLibrary)standardLibrary, childType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHazardous(@NonNull Mapping mapping) {
        return this.hazardousMappings.contains(mapping);
    }

    public boolean isHazardousRead(@NonNull Mapping asMapping, @NonNull NavigationCallExp asNavigationCallExp) {
        Area area;
        TypedModel typedModel;
        Area area2;
        TypedModel typedModel2;
        Property asProperty = PivotUtil.getReferredProperty((NavigationCallExp)asNavigationCallExp);
        OCLExpression asSource = asNavigationCallExp.getOwnedSource();
        DomainUsage domainUsage1 = this.domainAnalysis.basicGetUsage((Element)asSource);
        if (domainUsage1 != null && (typedModel2 = domainUsage1.getTypedModel((Element)asSource)) != null && (area2 = QVTcoreBaseUtil.getArea((AbstractMapping)asMapping, (TypedModel)typedModel2)) instanceof ImperativeArea && ((ImperativeArea)area2).getCheckedProperties().contains((Object)asProperty)) {
            return true;
        }
        Property asOppositeProperty = asProperty.getOpposite();
        DomainUsage domainUsage2 = this.domainAnalysis.basicGetUsage((Element)asNavigationCallExp);
        return domainUsage2 != null && (typedModel = domainUsage2.getTypedModel((Element)asProperty)) != null && (area = QVTcoreBaseUtil.getArea((AbstractMapping)asMapping, (TypedModel)typedModel)) instanceof ImperativeArea && ((ImperativeArea)area).getCheckedProperties().contains((Object)asOppositeProperty);
    }

    public boolean isHazardousWrite(@NonNull Mapping asMapping, @NonNull NavigationAssignment asNavigationAssignment) {
        TypedModel typedModel;
        Property asProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)asNavigationAssignment);
        OCLExpression asSource = asNavigationAssignment.getSlotExpression();
        DomainUsage domainUsage = this.getDomainUsageAnalysis().basicGetUsage((Element)asSource);
        if (domainUsage != null && (typedModel = domainUsage.getTypedModel((Element)asSource)) != null) {
            Mapping area = null;
            for (Domain domain : asMapping.getDomain()) {
                if (domain.getTypedModel() != typedModel) continue;
                area = (CoreDomain)domain;
                break;
            }
            if (area == null) {
                area = asMapping;
            }
            if (area instanceof ImperativeArea) {
                EList<Property> enforcedProperties = ((ImperativeArea)area).getEnforcedProperties();
                if (enforcedProperties.contains(asProperty)) {
                    return true;
                }
                if (enforcedProperties.contains(asProperty.getOpposite())) {
                    return true;
                }
            }
        }
        return false;
    }
}

