/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.net.URI;
import java.time.temporal.ChronoUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@Path(value="recovery-resource")
@ApplicationScoped
public class RecoveryResource {
    public static final String RECOVERY_RESOURCE_PATH = "recovery-resource";
    public static final String REQUIRED_PATH = "required";
    public static final String REQUIRED_TIMEOUT_PATH = "required-timeout";
    public static final long LRA_TIMEOUT = 500L;
    @Inject
    LRAMetricService lraMetricService;

    @PUT
    @Path(value="required")
    @LRA(value=LRA.Type.REQUIRED, end=false)
    public Response requiredLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="required-timeout")
    @LRA(value=LRA.Type.REQUIRED, end=false, timeLimit=500L, timeUnit=ChronoUnit.MILLIS)
    public Response requiredTimeoutLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/compensate")
    @Compensate
    public Response compensate(@HeaderParam(value="Long-Running-Action") URI lraId) {
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, RecoveryResource.class);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/after")
    @AfterLRA
    public Response afterLRA(@HeaderParam(value="Long-Running-Action-Ended") URI lraId, LRAStatus lraStatus) {
        this.lraMetricService.incrementMetric(LRAMetricType.valueOf(lraStatus.name()), lraId, RecoveryResource.class);
        return Response.ok().build();
    }
}

