/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.participant.api.ResourceParent;
import org.eclipse.microprofile.lra.tck.participant.api.Scenario;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="lraUnknownController")
public class LRAUnknownResource
extends ResourceParent {
    public static final String LRA_CONTROLLER_PATH = "lraUnknownController";
    public static final String TRANSACTIONAL_WORK_PATH = "work";
    private static final Logger LOGGER = Logger.getLogger(LRAUnknownResource.class.getName());
    private static final String AFTER_LRA = "/after";
    private Map<String, Scenario> scenarioMap = new HashMap<String, Scenario>();
    @Inject
    private LRAMetricService lraMetricService;

    @PUT
    @Path(value="work")
    @LRA
    public Response activityWithLRA(@HeaderParam(value="Long-Running-Action") URI lraId, @QueryParam(value="scenario") Scenario scenario) {
        this.scenarioMap.put(lraId.toASCIIString(), scenario);
        return Response.status((int)scenario.getPathResponseCode()).entity((Object)lraId).build();
    }

    @PUT
    @Path(value="/complete")
    @Produces(value={"application/json"})
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") URI lraId) throws NotFoundException {
        this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, LRAUnknownResource.class);
        int responseCode = 410;
        Scenario scenario = this.scenarioMap.get(lraId.toASCIIString());
        if (scenario == Scenario.COMPLETE_RETRY) {
            responseCode = 202;
            this.scenarioMap.remove(lraId.toASCIIString());
        }
        LOGGER.info(String.format("LRA id '%s' was completed", lraId.toASCIIString()));
        return Response.status((int)responseCode).build();
    }

    @PUT
    @Path(value="/compensate")
    @Produces(value={"application/json"})
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") URI lraId) throws NotFoundException {
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, LRAUnknownResource.class);
        int responseCode = 410;
        Scenario scenario = this.scenarioMap.get(lraId.toASCIIString());
        if (scenario == Scenario.COMPENSATE_RETRY) {
            responseCode = 202;
            this.scenarioMap.remove(lraId.toASCIIString());
        }
        LOGGER.info(String.format("LRA id '%s' was compensated", lraId));
        return Response.status((int)responseCode).build();
    }
}

