/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class LraTckConfigBean {
    private static final Long LRA_TIMEOUT_MILLIS = 50000L;
    public static final String LRA_TCK_TIMEOUT_FACTOR_PROPETY_NAME = "lra.tck.timeout.factor";
    public static final String LRA_TCK_BASE_URL_PROPERTY_NAME = "lra.tck.base.url";
    @Inject
    @ConfigProperty(name="lra.tck.timeout.factor", defaultValue="1.0")
    private double timeoutFactor;
    @Inject
    @ConfigProperty(name="lra.tck.base.url", defaultValue="http://localhost:8180/")
    private String tckSuiteBaseUrl;

    public long getDefaultTimeout() {
        return this.adjustTimeout(LRA_TIMEOUT_MILLIS);
    }

    public long adjustTimeout(long timeout) {
        return this.adjustTimeout(timeout, this.timeoutFactor);
    }

    private long adjustTimeout(long timeout, double timeoutFactor) {
        if (timeout < 0L || timeoutFactor < 0.0) {
            throw new IllegalArgumentException(String.format("Provided arguments (timeout=%d, timeoutFactor=%.2f) have to be positive", timeout, timeoutFactor));
        }
        return (long)Math.ceil((double)timeout * timeoutFactor);
    }
}

