/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.service;

import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
public class LRAMetricService {
    private Map<URI, Map<String, LRAMetric>> metricsPerLra = new HashMap<URI, Map<String, LRAMetric>>();

    public void incrementMetric(LRAMetricType metricType, URI lraId, Class<?> participantClazz) {
        String participantName = participantClazz.getName();
        this.metricsPerLra.putIfAbsent(lraId, new HashMap());
        this.metricsPerLra.get(lraId).putIfAbsent(participantName, new LRAMetric());
        this.metricsPerLra.get(lraId).get(participantName).increment(metricType);
    }

    public int getMetricAll(LRAMetricType metricType) {
        AtomicInteger result = new AtomicInteger();
        this.metricsPerLra.values().forEach(participantMap -> participantMap.values().forEach(metric -> result.addAndGet(metric.get(metricType))));
        return result.get();
    }

    public int getMetric(LRAMetricType metricType, URI lraId) {
        if (this.metricsPerLra.containsKey(lraId)) {
            return this.metricsPerLra.get(lraId).values().stream().mapToInt(lraMetric -> lraMetric.get(metricType)).sum();
        }
        return 0;
    }

    public int getMetric(LRAMetricType metricType, URI lraId, Class<?> participantClazz) {
        return this.getMetric(metricType, lraId, participantClazz.getName());
    }

    public int getMetric(LRAMetricType metricType, URI lraId, String participantClassName) {
        if (this.metricsPerLra.containsKey(lraId) && this.metricsPerLra.get(lraId).containsKey(participantClassName)) {
            return this.metricsPerLra.get(lraId).get(participantClassName).get(metricType);
        }
        return 0;
    }

    public void clear() {
        this.metricsPerLra.clear();
    }

    private static class LRAMetric {
        private Map<LRAMetricType, AtomicInteger> metrics = Arrays.stream(LRAMetricType.values()).collect(Collectors.toMap(Function.identity(), t -> new AtomicInteger(0)));

        private LRAMetric() {
        }

        void increment(LRAMetricType metricType) {
            if (!this.metrics.containsKey((Object)metricType)) {
                throw new IllegalArgumentException("Cannot increment metric type " + metricType.name());
            }
            this.metrics.get((Object)metricType).incrementAndGet();
        }

        int get(LRAMetricType metricType) {
            if (this.metrics.containsKey((Object)metricType)) {
                return this.metrics.get((Object)metricType).get();
            }
            return 0;
        }
    }
}

