/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.service;

import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@Path(value="lra-tck-metric")
public class LRAMetricRest {
    public static final String LRA_TCK_METRIC_RESOURCE_PATH = "lra-tck-metric";
    public static final String METRIC_PATH = "metric";
    public static final String METRIC_TYPE_PARAM = "metricType";
    public static final String LRA_ID_PARAM = "lraId";
    public static final String PARTICIPANT_NAME_PARAM = "participantName";
    @Inject
    private LRAMetricService lraMetricService;

    @Path(value="metric")
    @GET
    @Produces(value={"text/plain"})
    public int getMetric(@QueryParam(value="metricType") LRAMetricType metricType, @QueryParam(value="lraId") URI lra, @QueryParam(value="participantName") String participantName) {
        if (metricType == null) {
            throw new NullPointerException(METRIC_TYPE_PARAM);
        }
        if (lra == null) {
            throw new NullPointerException(LRA_ID_PARAM);
        }
        if (participantName == null) {
            throw new NullPointerException(PARTICIPANT_NAME_PARAM);
        }
        return this.lraMetricService.getMetric(metricType, lra, participantName);
    }
}

