/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.lsp4e.test.completion.AbstractCompletionTest;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class IncompleteCompletionTest
extends AbstractCompletionTest {
    @Test
    public void testAssistForUnknownButConnectedType() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFileOfUnknownType(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        LanguageServersRegistry.LanguageServerDefinition serverDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.lsp4e.test.server");
        Assertions.assertNotNull((Object)serverDefinition);
        LanguageServerWrapper lsWrapper = LanguageServiceAccessor.getLSWrapper((IProject)testFile.getProject(), (LanguageServersRegistry.LanguageServerDefinition)serverDefinition);
        URI fileLocation = testFile.getLocationURI();
        lsWrapper.connect(null, testFile);
        TestUtils.waitForAndAssertCondition(3000, () -> lsWrapper.isConnectedTo(fileLocation));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testNoPrefix() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testDeprecatedCompletion() throws Exception {
        BoldStylerProvider boldStyleProvider = null;
        try {
            ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
            CompletionItem completionItem = this.createCompletionItem("FirstClassDeprecated", CompletionItemKind.Class);
            completionItem.setDeprecated(Boolean.valueOf(true));
            items.add(completionItem);
            MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
            String content = "First";
            ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
            ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "First".length());
            Assertions.assertEquals((int)1, (int)proposals.length);
            LSCompletionProposal proposal = (LSCompletionProposal)proposals[0];
            StyledString simpleStyledStr = proposal.getStyledDisplayString();
            Assertions.assertEquals((Object)"FirstClassDeprecated", (Object)simpleStyledStr.getString());
            Assertions.assertEquals((int)1, (int)simpleStyledStr.getStyleRanges().length);
            StyleRange styleRange = simpleStyledStr.getStyleRanges()[0];
            Assertions.assertTrue((boolean)styleRange.strikeout);
            boldStyleProvider = new BoldStylerProvider(UI.getActiveShell().getFont());
            StyledString styledStr = proposal.getStyledDisplayString(viewer.getDocument(), 4, boldStyleProvider);
            Assertions.assertTrue((styledStr.getStyleRanges().length > 1 ? 1 : 0) != 0);
            StyleRange[] styleRangeArray = styledStr.getStyleRanges();
            int n = styleRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange sr = styleRangeArray[n2];
                Assertions.assertTrue((boolean)sr.strikeout);
                ++n2;
            }
        }
        finally {
            if (boldStyleProvider != null) {
                boldStyleProvider.dispose();
            }
        }
    }

    @Test
    public void testPrefix() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        items.add(this.createCompletionItem("SecondClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "First".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testPrefixCaseSensitivity() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "FIRST";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FIRST"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "FIRST".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompleteOnFileEnd() throws CoreException {
        CompletionItem item = new CompletionItem();
        item.setLabel("1024M");
        item.setKind(CompletionItemKind.Value);
        item.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(new Position(2, 10), new Position(2, 10)), "1024M")));
        CompletionList completionList = new CompletionList(true, List.of(item));
        MockLanguageServer.INSTANCE.setCompletionList(completionList);
        String content = "applications:\n- name: hello\n  memory: ";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "applications:\n- name: hello\n  memory: "));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "applications:\n- name: hello\n  memory: ".length());
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)"applications:\n- name: hello\n  memory: 1024M", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionWithAdditionalEditsBeforeOffsetInSameLine() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("additionaEditsCompletion");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("MainInsertText");
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 12), new Position(0, 12)), "addOnText2");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        item.setAdditionalTextEdits(additionalTextEdits);
        items.add(item);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "this <> is <> the main <> content of the file";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "this <> is <> the main <> content of the file");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 24);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        String newContent = viewer.getDocument().get();
        Assertions.assertEquals((Object)"this <addOnText1> is <addOnText2> the main <MainInsertText> content of the file", (Object)newContent);
    }

    @Test
    public void testCompletionWithAdditionalEditsBeforeAndAfterOffsetInSameLine() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("additionaEditsCompletion");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("MainInsertText");
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 24), new Position(0, 24)), "addOnText2");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        item.setAdditionalTextEdits(additionalTextEdits);
        items.add(item);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "this <> is <> the main <> content of the file";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "this <> is <> the main <> content of the file");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 12);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        String newContent = viewer.getDocument().get();
        Assertions.assertEquals((Object)"this <addOnText1> is <MainInsertText> the main <addOnText2> content of the file", (Object)newContent);
    }

    @Test
    public void testCompletionWithAdditionalEditsBeforeAndAfterOffsetInVariousLines() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("additionaEditsCompletion");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("MainInsertText");
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 24), new Position(0, 24)), "addOnText2");
        TextEdit additionaEdit3 = new TextEdit(new Range(new Position(1, 9), new Position(1, 9)), "addOnText3");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        additionalTextEdits.add(additionaEdit3);
        item.setAdditionalTextEdits(additionalTextEdits);
        items.add(item);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "this <> is <> the main <> content of the file\nthis is <> the second line";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "this <> is <> the main <> content of the file\nthis is <> the second line");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 12);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        String newContent = viewer.getDocument().get();
        Assertions.assertEquals((Object)"this <addOnText1> is <MainInsertText> the main <addOnText2> content of the file\nthis is <addOnText3> the second line", (Object)newContent);
    }

    @Test
    public void testCompletionWithAdditionalEditsBeforeAndAfterOffsetInVariousLinesAndTypedText() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        CompletionItem item = new CompletionItem("additionaEditsCompletion");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("MainInsertText");
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 24), new Position(0, 24)), "addOnText2");
        TextEdit additionaEdit3 = new TextEdit(new Range(new Position(1, 9), new Position(1, 9)), "addOnText3");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        additionalTextEdits.add(additionaEdit3);
        item.setAdditionalTextEdits(additionalTextEdits);
        items.add(item);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "this <> is <Main> the main <> content of the file\nthis is <> the second line";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "this <> is <Main> the main <> content of the file\nthis is <> the second line");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 12);
        Assertions.assertEquals((int)items.size(), (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument(), '\u0000', 16);
        String newContent = viewer.getDocument().get();
        Assertions.assertEquals((Object)"this <addOnText1> is <MainInsertText> the main <addOnText2> content of the file\nthis is <addOnText3> the second line", (Object)newContent);
    }

    @Test
    public void testSnippetCompletionWithAdditionalEdits() throws CoreException {
        CompletionItem item = new CompletionItem("snippet item");
        item.setInsertText("$1 and ${2:foo}");
        item.setKind(CompletionItemKind.Class);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        ArrayList<TextEdit> additionalTextEdits = new ArrayList<TextEdit>();
        TextEdit additionaEdit1 = new TextEdit(new Range(new Position(0, 6), new Position(0, 6)), "addOnText1");
        TextEdit additionaEdit2 = new TextEdit(new Range(new Position(0, 12), new Position(0, 12)), "addOnText2");
        additionalTextEdits.add(additionaEdit1);
        additionalTextEdits.add(additionaEdit2);
        item.setAdditionalTextEdits(additionalTextEdits);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(item)));
        String content = "this <> is <> the main <> content of the file";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "this <> is <> the main <> content of the file"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 24);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        String newContent = viewer.getDocument().get();
        Assertions.assertEquals((Object)"this <addOnText1> is <addOnText2> the main < and foo> content of the file", (Object)newContent);
    }

    @Test
    public void testApplyCompletionWithPrefix() throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 5));
        List<CompletionItem> items = List.of(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "First";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, "First".length());
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)true, (Object)viewer.getDocument().get().equals("FirstClass"));
        Assertions.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplace() throws CoreException {
        Range range = new Range(new Position(0, 0), new Position(0, 20));
        List<CompletionItem> items = List.of(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FirstNotMatchedLabel"));
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 5);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTypingWithTextEdit() throws CoreException, BadLocationException {
        Range range = new Range(new Position(0, 0), new Position(0, 22));
        List<CompletionItem> items = List.of(this.createCompletionItem("FirstClass", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "FirstNotMatchedLabel";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "FirstNotMatchedLabel"));
        int invokeOffset = 5;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace(5, 0, "No");
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)"FirstClass", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point("FirstClass".length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testApplyCompletionReplaceAndTyping() throws CoreException, BadLocationException {
        CompletionItem item = new CompletionItem("strncasecmp");
        item.setKind(CompletionItemKind.Function);
        item.setInsertText("strncasecmp()");
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(item)));
        String content = "str";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "str"));
        int invokeOffset = "str".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        viewer.getDocument().replace("str".length(), 0, "nc");
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)item.getInsertText(), (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(item.getInsertText().length(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionReplace() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "line1\nlineInsertHere");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(this.createCompletionItem("Inserted", CompletionItemKind.Text, new Range(new Position(1, 4), new Position(1, 4 + "InsertHere".length()))))));
        int invokeOffset = viewer.getDocument().getLength() - "InsertHere".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        LSIncompleteCompletionProposal.apply(viewer.getDocument());
        Assertions.assertEquals((Object)"line1\nlineInserted", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(viewer.getDocument().getLength(), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testItemOrdering() throws Exception {
        Range range = new Range(new Position(0, 0), new Position(0, 1));
        List<CompletionItem> items = List.of(this.createCompletionItem("AA", CompletionItemKind.Class, range), this.createCompletionItem("AB", CompletionItemKind.Class, range), this.createCompletionItem("BA", CompletionItemKind.Class, range), this.createCompletionItem("BB", CompletionItemKind.Class, range), this.createCompletionItem("CB", CompletionItemKind.Class, range), this.createCompletionItem("CC", CompletionItemKind.Class, range));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        String content = "B";
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "B"));
        int invokeOffset = 1;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)4, (int)proposals.length);
        Assertions.assertEquals((Object)"BA", (Object)proposals[0].getDisplayString());
        Assertions.assertEquals((Object)"BB", (Object)proposals[1].getDisplayString());
        Assertions.assertEquals((Object)"AB", (Object)proposals[2].getDisplayString());
        Assertions.assertEquals((Object)"CB", (Object)proposals[3].getDisplayString());
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        Assertions.assertEquals((Object)"BA", (Object)viewer.getDocument().get());
    }

    @Test
    public void testBasicSnippet() throws CoreException {
        CompletionItem completionItem = this.createCompletionItem("$1 and ${2:foo}", CompletionItemKind.Class, new Range(new Position(0, 0), new Position(0, 1)));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(completionItem)));
        ITextViewer viewer = TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, ""));
        int invokeOffset = 0;
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        Assertions.assertEquals((int)1, (int)proposals.length);
        ((LSCompletionProposal)proposals[0]).apply(viewer.getDocument());
        Assertions.assertEquals((Object)" and foo", (Object)viewer.getDocument().get());
    }

    @Test
    public void testMultipleLS() throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFileMultiLS(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)(2 * items.size()), (int)proposals.length);
    }

    @Test
    public void testCompletionWithAdditionalTextEditInsertion() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Some Text Before\n<tag>tagText</tag>\nSome Text After");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        CompletionItem item = this.createCompletionItem("tagText", CompletionItemKind.Text, new Range(new Position(1, "<tag>".length()), new Position(1, "<tag>".length() + "tag".length())));
        ArrayList<TextEdit> additionalEdits = new ArrayList<TextEdit>(2);
        additionalEdits.add(new TextEdit(new Range(new Position(1, 0), new Position(1, 0)), "<prefix>prefixText</prefix>\n"));
        additionalEdits.add(new TextEdit(new Range(new Position(1, "<tag>tag</tag>".length()), new Position(1, "<tag>tag</tag>".length())), "\n<postfix>postfixText</postfix>"));
        item.setAdditionalTextEdits(additionalEdits);
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of(item)));
        String text = viewer.getDocument().get();
        int invokeOffset = text.indexOf("<tag>tag") + "<tag>tag".length();
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, invokeOffset);
        LSCompletionProposal LSIncompleteCompletionProposal = (LSCompletionProposal)proposals[0];
        int currentOffset = invokeOffset + "Text".length();
        LSIncompleteCompletionProposal.apply(viewer.getDocument(), '\u0000', currentOffset);
        String expectedText = "Some Text Before\n<prefix>prefixText</prefix>\n<tag>tagText</tag>\n<postfix>postfixText</postfix>\nSome Text After";
        Assertions.assertEquals((Object)"Some Text Before\n<prefix>prefixText</prefix>\n<tag>tagText</tag>\n<postfix>postfixText</postfix>\nSome Text After", (Object)viewer.getDocument().get());
        Assertions.assertEquals((Object)new Point(viewer.getDocument().get().indexOf("</tag>"), 0), (Object)LSIncompleteCompletionProposal.getSelection(viewer.getDocument()));
    }

    @Test
    public void testCompletionExternalFile(@TempDir Path tempDir) throws Exception {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClassExternal", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        Path file = Files.createFile(tempDir.resolve("testCompletionExternalFile.lspt"), new FileAttribute[0]);
        ITextEditor editor = (ITextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toUri()));
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)1, (int)proposals.length);
        proposals[0].apply(viewer.getDocument());
        Assertions.assertEquals((Object)"FirstClassExternal", (Object)viewer.getDocument().get());
    }

    @Test
    public void testAdditionalInformation() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, new CompletionItem("blah"), wrapper);
        completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAdditionalInformationWithEmptyDetail() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDetail("");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, wrapper);
        String addInfo = (String)completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)addInfo.isEmpty());
    }

    @Test
    public void testAdditionalInformationWithDetail() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDetail("detail");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, wrapper);
        String addInfo = (String)completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((addInfo.indexOf("<p>detail</p>") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAdditionalInformationWithEmptyDocumentation() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDocumentation("");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, wrapper);
        String addInfo = (String)completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assertions.assertTrue((boolean)addInfo.isEmpty());
    }

    @Test
    public void testAdditionalInformationWithDocumentation() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IDocument document = TestUtils.openTextViewer(testFile).getDocument();
        LanguageServerWrapper wrapper = (LanguageServerWrapper)LanguageServiceAccessor.getLSWrappers((IFile)testFile, capabilities -> capabilities.getCompletionProvider() != null || capabilities.getSignatureHelpProvider() != null).get(0);
        CompletionItem item = new CompletionItem("blah");
        item.setDocumentation("documentation");
        LSCompletionProposal completionProposal = new LSCompletionProposal(document, 0, item, wrapper);
        String addInfo = (String)completionProposal.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        Assertions.assertFalse((boolean)addInfo.isEmpty());
    }

    @Test
    public void testIncompleteIndication() throws CoreException {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        items.add(this.createCompletionItem("FirstClass", CompletionItemKind.Class));
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, items));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)1, (int)proposals.length);
        LSContentAssistProcessor incompleIndicatingProcessor = new LSContentAssistProcessor(true, true);
        ICompletionProposal[] proposalsWithIncompleteProposal = incompleIndicatingProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)2, (int)proposalsWithIncompleteProposal.length);
        Assertions.assertEquals((Object)"FirstClass", (Object)proposals[0].getDisplayString());
        Assertions.assertEquals((Object)"FirstClass", (Object)proposalsWithIncompleteProposal[0].getDisplayString());
        Assertions.assertEquals((Object)"\u2795 Continue typing for more proposals...", (Object)proposalsWithIncompleteProposal[1].getDisplayString());
    }

    @Test
    public void testIncompleteIndicationWithEmptyList() throws CoreException {
        MockLanguageServer.INSTANCE.setCompletionList(new CompletionList(true, List.of()));
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ICompletionProposal[] proposals = this.contentAssistProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)0, (int)proposals.length);
        LSContentAssistProcessor incompleIndicatingProcessor = new LSContentAssistProcessor(true, true);
        ICompletionProposal[] proposalsWithIncompleteProposal = incompleIndicatingProcessor.computeCompletionProposals(viewer, 0);
        Assertions.assertEquals((int)0, (int)proposalsWithIncompleteProposal.length);
    }
}

