/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageProducer;

public class ConcurrentMessageProcessor
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ConcurrentMessageProcessor.class.getName());
    private boolean isRunning;
    private final MessageProducer messageProducer;
    private final MessageConsumer messageConsumer;

    public static Future<Void> wrapFuture(final Future<?> result, final MessageProducer messageProducer) {
        return new Future<Void>(){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                return (Void)result.get();
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return (Void)result.get(timeout, unit);
            }

            @Override
            public boolean isDone() {
                return result.isDone();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning && messageProducer instanceof Closeable) {
                    try {
                        ((Closeable)((Object)messageProducer)).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return result.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return result.isCancelled();
            }
        };
    }

    public ConcurrentMessageProcessor(MessageProducer messageProducer, MessageConsumer messageConsumer) {
        this.messageProducer = messageProducer;
        this.messageConsumer = messageConsumer;
    }

    public Future<Void> beginProcessing(ExecutorService executorService) {
        Future<?> result = executorService.submit(this);
        return ConcurrentMessageProcessor.wrapFuture(result, this.messageProducer);
    }

    @Override
    public void run() {
        this.processingStarted();
        try {
            this.messageProducer.listen(this.messageConsumer);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.processingEnded();
        }
    }

    protected void processingStarted() {
        if (this.isRunning) {
            throw new IllegalStateException("The message processor is already running.");
        }
        this.isRunning = true;
    }

    protected void processingEnded() {
        this.isRunning = false;
    }
}

