/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.rename;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.operations.rename.LSPInlineRenameLinkedMode;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LSPInlineRenameLinkedModeTest
extends AbstractTestWithProject {
    LSPInlineRenameLinkedModeTest() {
    }

    @Test
    void testInlineLinkedEditingSameFile() throws Exception {
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").putBoolean("org.eclipse.lsp4e.inlineRename", true);
        String content = "compute();\ncompute();";
        IFile file = TestUtils.createUniqueTestFile(this.project, content);
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        int idLength = "compute".length();
        int firstOffset = content.indexOf("compute");
        int secondOffset = content.indexOf("compute", firstOffset + 1);
        Region primaryRegion = new Region(firstOffset, idLength);
        Position caretPosition = LSPEclipseUtils.toPosition((int)firstOffset, (IDocument)document);
        HashMap<Position, List<DocumentHighlight>> highlights = new HashMap<Position, List<DocumentHighlight>>();
        highlights.put(caretPosition, List.of(new DocumentHighlight(new Range(new Position(0, 0), new Position(0, idLength)), DocumentHighlightKind.Read), new DocumentHighlight(new Range(new Position(1, 0), new Position(1, idLength)), DocumentHighlightKind.Read), new DocumentHighlight(new Range(new Position(0, 0), new Position(0, idLength)), DocumentHighlightKind.Text)));
        MockLanguageServer.INSTANCE.setDocumentHighlights(highlights);
        Method collectSameFileOccurrences = LSPInlineRenameLinkedMode.class.getDeclaredMethod("collectSameFileOccurrences", IDocument.class, Integer.TYPE, IRegion.class);
        collectSameFileOccurrences.setAccessible(true);
        List regions = (List)collectSameFileOccurrences.invoke(null, document, firstOffset, primaryRegion);
        Assertions.assertEquals((int)firstOffset, (int)((IRegion)regions.get(0)).getOffset());
        Assertions.assertEquals((int)idLength, (int)((IRegion)regions.get(0)).getLength());
        Assertions.assertEquals((int)2, (int)regions.size());
        Assertions.assertEquals((int)secondOffset, (int)((IRegion)regions.get(1)).getOffset());
        Assertions.assertEquals((int)idLength, (int)((IRegion)regions.get(1)).getLength());
    }

    @Test
    void testInlineRenameEndToEndSameFile() throws Exception {
        String content = "compute();\ncompute();";
        IFile file = TestUtils.createUniqueTestFile(this.project, content);
        IDocument document = LSPEclipseUtils.getDocument((IResource)file);
        Assertions.assertNotNull((Object)document);
        int idLength = "compute".length();
        int firstOffset = content.indexOf("compute");
        int secondOffset = content.indexOf("compute", firstOffset + 1);
        String typedName = "inlineName";
        Position firstPos = LSPEclipseUtils.toPosition((int)firstOffset, (IDocument)document);
        Position secondPos = LSPEclipseUtils.toPosition((int)secondOffset, (IDocument)document);
        Range prepareRange = new Range(firstPos, new Position(firstPos.getLine(), firstPos.getCharacter() + idLength));
        MockLanguageServer.INSTANCE.getTextDocumentService().setPrepareRenameResult(Either.forLeft((Object)prepareRange));
        HashMap<String, List<TextEdit>> edits = new HashMap<String, List<TextEdit>>();
        String uri = LSPEclipseUtils.toUri((IResource)file).toString();
        edits.put(uri, List.of(new TextEdit(new Range(firstPos, new Position(firstPos.getLine(), firstPos.getCharacter() + idLength)), typedName), new TextEdit(new Range(secondPos, new Position(secondPos.getLine(), secondPos.getCharacter() + idLength)), typedName)));
        MockLanguageServer.INSTANCE.getTextDocumentService().setRenameEdit(new WorkspaceEdit(edits));
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Constructor constructor = LSPInlineRenameLinkedMode.class.getDeclaredConstructor(IDocument.class, ITextViewer.class, Integer.TYPE, IRegion.class, String.class, List.class, LanguageServerWrapper.class);
        constructor.setAccessible(true);
        Region renameRegion = new Region(firstOffset, idLength);
        List<Region> occurrences = List.of(renameRegion, new Region(secondOffset, idLength));
        LSPInlineRenameLinkedMode mode = (LSPInlineRenameLinkedMode)constructor.newInstance(document, viewer, firstOffset, renameRegion, "compute", occurrences, null);
        int delta = typedName.length() - idLength;
        document.replace(firstOffset, idLength, typedName);
        document.replace(secondOffset + delta, idLength, typedName);
        Field linkedPosField = LSPInlineRenameLinkedMode.class.getDeclaredField("linkedPosition");
        linkedPosField.setAccessible(true);
        linkedPosField.set(mode, new LinkedPosition(document, firstOffset, typedName.length()));
        Method schedule = LSPInlineRenameLinkedMode.class.getDeclaredMethod("scheduleRenameJob", new Class[0]);
        schedule.setAccessible(true);
        schedule.invoke((Object)mode, new Object[0]);
        TestUtils.waitForAndAssertCondition("Inline rename workspace edit not applied", 5000, () -> {
            Assertions.assertEquals((Object)(typedName + "();\n" + typedName + "();"), (Object)document.get());
            return true;
        });
    }
}

