/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.commands;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceFoldersOptions;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynamicRegistrationTest
extends AbstractTestWithProject {
    private static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";
    private static final String WORKSPACE_DID_CHANGE_FOLDERS = "workspace/didChangeWorkspaceFolders";
    private static final String WORKSPACE_DID_CHANGE_WATCHED_FILES = "workspace/didChangeWatchedFiles";

    @BeforeEach
    public void setUp() throws Exception {
        IFile testFile = TestUtils.createFile(this.project, "shouldUseExtension.lspt", "");
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assertions.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        TestUtils.waitForCondition(5000, () -> !MockLanguageServer.INSTANCE.getRemoteProxies().isEmpty());
        this.getMockClient();
    }

    @Test
    public void testCommandRegistration() throws Exception {
        Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> true));
        Assertions.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command")));
        UUID registration = this.registerCommands("test.command", "test.command.2");
        try {
            Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command")));
            Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command.2")));
        }
        finally {
            this.unregister(registration, WORKSPACE_EXECUTE_COMMAND);
        }
        Assertions.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command")));
        Assertions.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(this.handlesCommand("test.command.2")));
    }

    @Test
    public void testWatchedFilesRegistrationAndNotification() throws Exception {
        Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> true));
        UUID registration = this.registerWatchedFiles();
        try {
            MockWorkspaceService workspaceService = MockLanguageServer.INSTANCE.getWorkspaceService();
            TestUtils.createFile(this.project, "watched.txt", "");
            TestUtils.createFile(this.project, "unwatched.bin", "");
            TestUtils.waitForCondition(5000, () -> !workspaceService.getWatchedFilesEvents().isEmpty());
            DidChangeWatchedFilesParams params = (DidChangeWatchedFilesParams)workspaceService.getWatchedFilesEvents().get(0);
            Assertions.assertFalse((boolean)params.getChanges().isEmpty());
            Assertions.assertTrue((boolean)params.getChanges().stream().anyMatch(ev -> ev.getUri().endsWith("watched.txt") && ev.getType() == FileChangeType.Created));
            Assertions.assertFalse((boolean)params.getChanges().stream().anyMatch(ev -> ev.getUri().endsWith("unwatched.bin")));
        }
        finally {
            this.unregister(registration, WORKSPACE_DID_CHANGE_WATCHED_FILES);
        }
    }

    @Test
    public void testWorkspaceFoldersRegistration() throws Exception {
        Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> true));
        Assertions.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
        UUID registration = this.registerWorkspaceFolders();
        try {
            Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
        }
        finally {
            this.unregister(registration, WORKSPACE_DID_CHANGE_FOLDERS);
        }
        Assertions.assertFalse((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
        Assertions.assertTrue((boolean)LanguageServiceAccessor.hasActiveLanguageServers(c -> !this.hasWorkspaceFolderSupport((ServerCapabilities)c)));
    }

    private void unregister(UUID registration, String method) throws Exception {
        LanguageClient client = this.getMockClient();
        Unregistration unregistration = new Unregistration(registration.toString(), method);
        client.unregisterCapability(new UnregistrationParams(List.of(unregistration))).get(1L, TimeUnit.SECONDS);
    }

    private UUID registerWatchedFiles() throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_DID_CHANGE_WATCHED_FILES);
        DidChangeWatchedFilesRegistrationOptions options = new DidChangeWatchedFilesRegistrationOptions();
        FileSystemWatcher watcher = new FileSystemWatcher(Either.forLeft((Object)"**/*.txt"), null);
        options.setWatchers(List.of(watcher));
        registration.setRegisterOptions((Object)options);
        client.registerCapability(new RegistrationParams(List.of(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private UUID registerWorkspaceFolders() throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_DID_CHANGE_FOLDERS);
        client.registerCapability(new RegistrationParams(List.of(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private UUID registerCommands(String ... command) throws Exception {
        UUID id = UUID.randomUUID();
        LanguageClient client = this.getMockClient();
        Registration registration = new Registration();
        registration.setId(id.toString());
        registration.setMethod(WORKSPACE_EXECUTE_COMMAND);
        registration.setRegisterOptions((Object)new ExecuteCommandOptions(List.of(command)));
        client.registerCapability(new RegistrationParams(List.of(registration))).get(1L, TimeUnit.SECONDS);
        return id;
    }

    private LanguageClient getMockClient() {
        List proxies = MockLanguageServer.INSTANCE.getRemoteProxies();
        Assertions.assertEquals((int)1, (int)proxies.size());
        return (LanguageClient)proxies.get(0);
    }

    private Predicate<ServerCapabilities> handlesCommand(String command) {
        return cap -> {
            ExecuteCommandOptions commandProvider = cap.getExecuteCommandProvider();
            return commandProvider != null && commandProvider.getCommands().contains(command);
        };
    }

    private boolean hasWorkspaceFolderSupport(ServerCapabilities cap) {
        WorkspaceFoldersOptions f;
        WorkspaceServerCapabilities ws;
        if (cap != null && (ws = cap.getWorkspace()) != null && (f = ws.getWorkspaceFolders()) != null) {
            return f.getSupported();
        }
        return false;
    }
}

