/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.TransportStreams;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.ProcessEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DebugSessionTerminationTest
extends AbstractTestWithProject {
    private static final String LAUNCH_TYPE_ID = "org.eclipse.lsp4e.debug.launchType";

    DebugSessionTerminationTest() {
    }

    private static ILaunch newLaunch(String mode) throws Exception {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_TYPE_ID);
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, "DebugSessionTerminationTest-" + System.currentTimeMillis());
        return new Launch((ILaunchConfiguration)wc, mode, null);
    }

    @Test
    void testTerminatedDoesNotPreventExited() throws Exception {
        ILaunch launch = DebugSessionTerminationTest.newLaunch("run");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "mock");
        params.put("request", "launch");
        params.put("program", "dummy");
        MockDebugServer server = new MockDebugServer();
        TestDebugTarget target = new TestDebugTarget(launch, params, server);
        target.initialize((IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForAndAssertCondition(5000, () -> ((TestDebugTarget)target).isTerminated());
        Assertions.assertTrue((boolean)target.isTerminated(), (String)"Debug target should be terminated");
        Assertions.assertTrue((boolean)server.exitedDelivered.get(), (String)"Debug adapter exited event should be deliverable after terminated");
        Assertions.assertEquals((int)0, (int)server.terminateRequestCount.get(), (String)"LSP4E must not send terminate request back to adapter after receiving terminated event");
        Assertions.assertEquals((int)0, (int)server.disconnectRequestCount.get(), (String)"LSP4E must not send disconnect request back to adapter after receiving terminated event");
    }

    @Test
    void testTerminatedWithoutExitedCleansUpWithoutAdapterTerminate() throws Exception {
        ILaunch launch = DebugSessionTerminationTest.newLaunch("run");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "mock");
        params.put("request", "launch");
        params.put("program", "dummy");
        MockTerminatedOnlyServer server = new MockTerminatedOnlyServer();
        TestDebugTarget target = new TestDebugTarget(launch, params, server);
        target.initialize((IProgressMonitor)new NullProgressMonitor());
        TestUtils.waitForAndAssertCondition(5000, server.terminatedDelivered::get);
        TestUtils.waitForAndAssertCondition(5000, () -> ((TestDebugTarget)target).isTerminated());
        Assertions.assertTrue((boolean)target.isTerminated(), (String)"Debug target should be terminated after adapter-only terminated event");
        Assertions.assertEquals((int)0, (int)server.terminateRequestCount.get(), (String)"LSP4E must not send terminate request back to adapter after receiving terminated event");
        Assertions.assertEquals((int)0, (int)server.disconnectRequestCount.get(), (String)"LSP4E must not send disconnect request back to adapter after receiving terminated event");
    }

    private static final class MockDebugServer
    implements IDebugProtocolServer {
        IDebugProtocolClient client;
        final AtomicBoolean exitedDelivered = new AtomicBoolean(false);
        final AtomicInteger terminateRequestCount = new AtomicInteger(0);
        final AtomicInteger disconnectRequestCount = new AtomicInteger(0);

        private MockDebugServer() {
        }

        public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
            Capabilities caps = new Capabilities();
            caps.setSupportsTerminateRequest(Boolean.valueOf(true));
            if (this.client != null) {
                this.client.initialized();
            }
            return CompletableFuture.completedFuture(caps);
        }

        public CompletableFuture<Void> launch(Map<String, Object> args) {
            if (this.client != null) {
                ProcessEventArguments process = new ProcessEventArguments();
                process.setName("mock-debuggee");
                this.client.process(process);
                TerminatedEventArguments terminated = new TerminatedEventArguments();
                this.client.terminated(terminated);
                ExitedEventArguments exited = new ExitedEventArguments();
                exited.setExitCode(0);
                try {
                    this.client.exited(exited);
                    this.exitedDelivered.set(true);
                }
                catch (Throwable t) {
                    this.exitedDelivered.set(false);
                }
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> terminate(TerminateArguments args) {
            this.terminateRequestCount.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> disconnect(DisconnectArguments args) {
            this.disconnectRequestCount.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }
    }

    private static final class MockTerminatedOnlyServer
    implements IDebugProtocolServer {
        IDebugProtocolClient client;
        final AtomicBoolean terminatedDelivered = new AtomicBoolean(false);
        final AtomicInteger terminateRequestCount = new AtomicInteger(0);
        final AtomicInteger disconnectRequestCount = new AtomicInteger(0);

        private MockTerminatedOnlyServer() {
        }

        public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
            Capabilities caps = new Capabilities();
            caps.setSupportsTerminateRequest(Boolean.valueOf(true));
            if (this.client != null) {
                this.client.initialized();
            }
            return CompletableFuture.completedFuture(caps);
        }

        public CompletableFuture<Void> launch(Map<String, Object> args) {
            if (this.client != null) {
                ProcessEventArguments process = new ProcessEventArguments();
                process.setName("mock-debuggee");
                this.client.process(process);
                TerminatedEventArguments terminated = new TerminatedEventArguments();
                this.client.terminated(terminated);
                this.terminatedDelivered.set(true);
            }
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> terminate(TerminateArguments args) {
            this.terminateRequestCount.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<Void> disconnect(DisconnectArguments args) {
            this.disconnectRequestCount.incrementAndGet();
            return CompletableFuture.completedFuture(null);
        }
    }

    private static final class TestDebugTarget
    extends DSPDebugTarget {
        private final IDebugProtocolServer server;

        TestDebugTarget(ILaunch launch, Map<String, Object> dspParameters, IDebugProtocolServer server) {
            super(launch, () -> new TransportStreams.DefaultTransportStreams(InputStream.nullInputStream(), OutputStream.nullOutputStream()), dspParameters);
            this.server = server;
        }

        protected Launcher<? extends IDebugProtocolServer> createLauncher(UnaryOperator<MessageConsumer> wrapper, InputStream in, OutputStream out, ExecutorService threadPool) {
            IDebugProtocolServer iDebugProtocolServer = this.server;
            if (iDebugProtocolServer instanceof MockDebugServer) {
                MockDebugServer m = (MockDebugServer)iDebugProtocolServer;
                m.client = this;
            } else {
                IDebugProtocolServer iDebugProtocolServer2 = this.server;
                if (iDebugProtocolServer2 instanceof MockTerminatedOnlyServer) {
                    MockTerminatedOnlyServer m = (MockTerminatedOnlyServer)iDebugProtocolServer2;
                    m.client = this;
                }
            }
            return new Launcher<IDebugProtocolServer>(){

                public RemoteEndpoint getRemoteEndpoint() {
                    return null;
                }

                public IDebugProtocolServer getRemoteProxy() {
                    return server;
                }

                public CompletableFuture<Void> startListening() {
                    return CompletableFuture.completedFuture(null);
                }
            };
        }
    }
}

