/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.statespace;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.games.ratio.solvers.policy.RatioGamePolicyIteration;
import org.eclipse.lsat.common.ludus.backend.statespace.Configuration;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;

public class MaxPlusGame
implements RatioGamePolicyIteration<Configuration, Transition, Value> {
    private static final long serialVersionUID = 1L;
    private final Set<Configuration> v0 = new HashSet<Configuration>();
    private final Set<Configuration> v1 = new HashSet<Configuration>();
    private final Set<Configuration> vertices;
    private final Map<Configuration, Integer> vertexIds = new HashMap<Configuration, Integer>();
    private final Set<Transition> transitions;
    private final Map<Configuration, Set<Transition>> outgoingMap;
    private final Map<Configuration, Set<Transition>> incomingMap;
    private final Map<Transition, Value> weightMap1;
    private final Map<Transition, Value> weightMap2;
    private final Value maxWeight;

    public MaxPlusGame(MaxPlusStateSpace stateSpace, Set<String> controllableEvents, Set<String> uncontrollableEvents) {
        this.vertices = stateSpace.getConfigurations();
        this.transitions = new HashSet<Transition>();
        this.outgoingMap = new HashMap<Configuration, Set<Transition>>();
        this.incomingMap = new HashMap<Configuration, Set<Transition>>();
        this.weightMap1 = new HashMap<Transition, Value>();
        this.weightMap2 = new HashMap<Transition, Value>();
        for (Configuration c : this.vertices) {
            for (Transition transition : stateSpace.outgoingEdgesOf(c)) {
                this.addIncoming(transition.getTarget(), transition);
                this.addOutgoing(c, transition);
                this.weightMap1.put(transition, transition.getDuration());
                this.weightMap2.put(transition, transition.getReward());
            }
        }
        int id = 0;
        for (Configuration c : this.vertices) {
            if (this.allInSet(c, controllableEvents)) {
                this.v0.add(c);
            } else if (this.allInSet(c, uncontrollableEvents)) {
                this.v1.add(c);
            } else {
                System.out.println("Configuration found with two types of outgoing edges! " + c.toString());
            }
            this.vertexIds.put(c, id);
            ++id;
        }
        Value max1 = this.weightMap1.values().stream().reduce((i, j) -> i.max((Value)j)).get();
        Value value = this.weightMap2.values().stream().reduce((i, j) -> i.max((Value)j)).get();
        this.maxWeight = Value.max(max1.abs(), value.abs());
    }

    private boolean allInSet(Configuration c, Set<String> eventSet) {
        return this.outgoingEdgesOf(c).stream().noneMatch(t -> !eventSet.contains(t.getEvent()));
    }

    private void addIncoming(Configuration c, Transition t) {
        if (this.incomingMap.containsKey(c)) {
            this.incomingMap.get(c).add(t);
        } else {
            HashSet<Transition> set = new HashSet<Transition>();
            set.add(t);
            this.incomingMap.put(c, set);
        }
    }

    private void addOutgoing(Configuration c, Transition t) {
        if (this.outgoingMap.containsKey(c)) {
            this.outgoingMap.get(c).add(t);
        } else {
            HashSet<Transition> set = new HashSet<Transition>();
            set.add(t);
            this.outgoingMap.put(c, set);
        }
    }

    @Override
    public Set<Configuration> getV0() {
        return this.v0;
    }

    @Override
    public Set<Configuration> getV1() {
        return this.v1;
    }

    @Override
    public Set<Configuration> getVertices() {
        return this.vertices;
    }

    @Override
    public Set<Transition> getEdges() {
        return this.transitions;
    }

    @Override
    public Collection<Transition> incomingEdgesOf(Configuration v) {
        return this.incomingMap.getOrDefault(v, Collections.emptySet());
    }

    @Override
    public Collection<Transition> outgoingEdgesOf(Configuration v) {
        return this.outgoingMap.getOrDefault(v, Collections.emptySet());
    }

    @Override
    public Configuration getEdgeSource(Transition e) {
        return e.getSource();
    }

    @Override
    public Configuration getEdgeTarget(Transition e) {
        return e.getTarget();
    }

    @Override
    public Transition getEdge(Configuration source, Configuration target) {
        for (Transition t : this.outgoingMap.get(source)) {
            if (!t.getTarget().equals(target)) continue;
            return t;
        }
        return null;
    }

    @Override
    public Value getWeight1(Transition edge) {
        return this.weightMap1.get(edge);
    }

    @Override
    public Value getWeight2(Transition edge) {
        return this.weightMap2.get(edge);
    }

    @Override
    public Value getMaxAbsValue() {
        return this.maxWeight;
    }

    @Override
    public Integer getId(Configuration vertex) {
        return this.vertexIds.get(vertex);
    }
}

