/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.metamodel.model.platform;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MatchRule implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    COMPATIBLE(1, "COMPATIBLE", "COMPATIBLE"),
    EQUIVALENT(2, "EQUIVALENT", "EQUIVALENT"),
    GREATER_OR_EQUAL(3, "GREATER_OR_EQUAL", "GREATER_OR_EQUAL"),
    NONE(4, "NONE", "NONE"),
    PERFECT(5, "PERFECT", "PERFECT"),
    PREFIX(6, "PREFIX", "PREFIX");

    public static final int UNSET_VALUE = 0;
    public static final int COMPATIBLE_VALUE = 1;
    public static final int EQUIVALENT_VALUE = 2;
    public static final int GREATER_OR_EQUAL_VALUE = 3;
    public static final int NONE_VALUE = 4;
    public static final int PERFECT_VALUE = 5;
    public static final int PREFIX_VALUE = 6;
    private static final MatchRule[] VALUES_ARRAY;
    public static final List<MatchRule> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MatchRule[]{UNSET, COMPATIBLE, EQUIVALENT, GREATER_OR_EQUAL, NONE, PERFECT, PREFIX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MatchRule get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatchRule result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatchRule getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MatchRule result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MatchRule get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return COMPATIBLE;
            }
            case 2: {
                return EQUIVALENT;
            }
            case 3: {
                return GREATER_OR_EQUAL;
            }
            case 4: {
                return NONE;
            }
            case 5: {
                return PERFECT;
            }
            case 6: {
                return PREFIX;
            }
        }
        return null;
    }

    private MatchRule(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

