/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.resource;

public class MappingConfig {
    private String kind;
    private String apiVersion;
    private String filenameTypes;

    public String[] getFilenamesAsArray() {
        if (this.filenameTypes == null) {
            return new String[0];
        }
        return this.filenameTypes.split(",\\s*");
    }

    public boolean isValid() {
        return this.kind != null && this.filenameTypes != null && this.filenameTypes.length() > 0;
    }

    public static MappingConfigBuilder builder() {
        return new MappingConfigBuilder();
    }

    public MappingConfigBuilder toBuilder() {
        return new MappingConfigBuilder().kind(this.kind).apiVersion(this.apiVersion).filenameTypes(this.filenameTypes);
    }

    public MappingConfig(String kind, String apiVersion, String filenameTypes) {
        this.kind = kind;
        this.apiVersion = apiVersion;
        this.filenameTypes = filenameTypes;
    }

    public MappingConfig() {
    }

    public String getKind() {
        return this.kind;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getFilenameTypes() {
        return this.filenameTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingConfig)) {
            return false;
        }
        MappingConfig other = (MappingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$filenameTypes = this.getFilenameTypes();
        String other$filenameTypes = other.getFilenameTypes();
        return !(this$filenameTypes == null ? other$filenameTypes != null : !this$filenameTypes.equals(other$filenameTypes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $filenameTypes = this.getFilenameTypes();
        result = result * 59 + ($filenameTypes == null ? 43 : $filenameTypes.hashCode());
        return result;
    }

    public static class MappingConfigBuilder {
        private String kind;
        private String apiVersion;
        private String filenameTypes;

        MappingConfigBuilder() {
        }

        public MappingConfigBuilder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public MappingConfigBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public MappingConfigBuilder filenameTypes(String filenameTypes) {
            this.filenameTypes = filenameTypes;
            return this;
        }

        public MappingConfig build() {
            return new MappingConfig(this.kind, this.apiVersion, this.filenameTypes);
        }

        public String toString() {
            return "MappingConfig.MappingConfigBuilder(kind=" + this.kind + ", apiVersion=" + this.apiVersion + ", filenameTypes=" + this.filenameTypes + ")";
        }
    }
}

