/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.remove.oneXone;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXone.A;
import ee.jakarta.tck.persistence.core.entitytest.remove.oneXone.B;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test1() throws Exception {
        this.logTrace("Begin remove1X1Test1");
        boolean pass = false;
        A a1 = new A("1", "a1", 1);
        B bRef = new B("1", "b1", 1, a1);
        try {
            this.getEntityTransaction().begin();
            boolean result = this.getInstanceStatus(bRef);
            if (!result) {
                this.logTrace("Instance state is not managed as expected. Try invoking remove on it.");
                this.getEntityManager().remove((Object)bRef);
                pass = true;
            } else {
                this.logErr("Instance state is managed.  Unexpected as this is NEW instance.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            this.logErr("Unexpected exception during remove operation. Should have been ignored.", fe);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test2() throws Exception {
        this.logTrace("Begin remove1X1Test2");
        boolean pass = true;
        A a1 = new A("2", "a2", 2);
        B bRef = new B("2", "b2", 2, a1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance Status ");
            if (this.getInstanceStatus(bRef)) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)bRef);
                this.logTrace("Call contains after remove()");
                pass = this.getEntityManager().contains((Object)bRef);
            } else {
                this.logErr("Instance is not managed, cannot proceed with test");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (pass) {
            throw new Exception("remove1X1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test3() throws Exception {
        this.logTrace("Begin remove1X1Test3");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("3", "a3", 3);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("3", "a3", 3, a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance Status ");
            A a2 = bRef.getA1();
            status = this.getInstanceStatus(bRef);
            if (status && a2 == a1) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)bRef);
                this.logTrace("Remove is immediately visible to the contains method");
                if (!this.getEntityManager().contains((Object)a2) && !this.getEntityManager().contains((Object)bRef)) {
                    pass = true;
                }
            } else {
                this.logTrace("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logTrace("Expected Exception :", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test4() throws Exception {
        boolean pass = false;
        boolean status = false;
        A a1 = new A("4", "a4", 4);
        B bRef = new B("4", "b4", 4, a1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance Status ");
            status = this.getEntityManager().contains((Object)bRef);
            if (status) {
                this.logTrace("entity is managed, remove");
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
                B stillExists = this.findB("4");
                if (stillExists == null) {
                    this.getEntityManager().remove((Object)bRef);
                    pass = true;
                }
            } else {
                this.logTrace("entity not managed, unexpected, test fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test5() throws Exception {
        this.logTrace("Begin remove1X1Test5");
        boolean pass = false;
        boolean status = false;
        A a1 = new A("5", "a5", 5);
        B bRef = new B("5", "a5", 5, a1);
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance ");
            A a2 = bRef.getA1();
            this.logTrace("get Instance Status ");
            status = this.getInstanceStatus(bRef);
            if (status && a2 == a1) {
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
                B newB = this.findB("5");
                if (newB == null && !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1)) {
                    pass = true;
                }
            } else {
                this.logTrace("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test5 failed");
        }
    }

    public void remove1X1Test6() throws Exception {
        this.logTrace("Begin remove1X1Test6");
        boolean pass = false;
        boolean status = false;
        this.getEntityTransaction().begin();
        A a1 = new A("6", "a6", 6);
        this.getEntityManager().persist((Object)a1);
        B bRef = new B("6", "a6", 6, a1);
        this.getEntityManager().persist((Object)bRef);
        this.logTrace("get Instance ");
        A a2 = bRef.getA1();
        this.logTrace("get Instance Status ");
        status = this.getInstanceStatus(bRef);
        if (status && a2 == a1) {
            try {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)this.findB("6"));
                this.getEntityManager().flush();
                this.logTrace("A removed entity is removed from the database as a result of the flush operation");
                B newB = this.findB("6");
                if (newB == null && !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception onfe) {
                this.logErr("Unexpected Exception :" + onfe);
            }
        } else {
            this.logTrace("Instance is not managed- Unexpected");
            pass = false;
        }
        if (!pass) {
            throw new Exception("remove1X1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test7() throws Exception {
        this.logTrace("Begin remove1X1Test7");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("7", "a7", 7);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("7", "a7", 7, a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance ");
            A a2 = bRef.getA1();
            this.logTrace("get Instance Status ");
            status = this.getEntityManager().contains((Object)bRef);
            if (status && a2 == a1) {
                this.logTrace("Status is true as expected, try remove()");
                this.getEntityManager().remove((Object)bRef);
                if (!this.getEntityManager().contains((Object)bRef)) {
                    pass = true;
                }
            } else {
                this.logTrace("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test8() throws Exception {
        this.logTrace("Begin remove1X1Test8");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "a8", 8);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("8", "a8", 8, a1);
            this.getEntityManager().persist((Object)bRef);
            this.logTrace("get Instance ");
            A a2 = bRef.getA1();
            this.logTrace("get Instance Status ");
            status = this.getInstanceStatus(bRef);
            if (status && a2 == a1) {
                this.getEntityManager().remove((Object)bRef);
                if (!this.getEntityManager().contains((Object)a2)) {
                    pass = true;
                }
            } else {
                this.logTrace("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove1X1Test9() throws Exception {
        this.logTrace("Begin remove1X1Test9");
        boolean pass = false;
        boolean status = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("9", "a9", 9);
            this.getEntityManager().persist((Object)a1);
            B bRef = new B("9", "b9", 9, a1);
            this.logTrace("get Instance Status ");
            status = this.getEntityManager().contains((Object)a1);
            if (status) {
                this.logTrace("A Entity is persisted, bRef is new, remove should be ignored on bRef, a1 should be removed");
                this.getEntityManager().remove((Object)bRef);
                this.getEntityManager().flush();
                this.logTrace("Call contains after remove()");
                status = this.getEntityManager().contains((Object)a1);
                this.logTrace("Call contains after remove()");
                A stillExists = this.findA("9");
                if (!status && stillExists == null) {
                    pass = true;
                }
            } else {
                this.logTrace("Instance is not managed- Unexpected");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("remove1X1Test9 failed");
        }
    }

    private A findA(String id) {
        this.logTrace("Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        this.logTrace("Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        this.logTrace("Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

