/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManager;

import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Util;
import ee.jakarta.tck.persistence.core.entityManager.Employee;
import ee.jakarta.tck.persistence.core.entityManager.Order;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.StoredProcedureQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Client2
extends Util {
    List<Employee> empRef = new ArrayList<Employee>();
    Employee emp0 = null;
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    String dataBaseName = null;
    static final String ORACLE = "oracle";
    static final String POSTGRESQL = "postgresql";

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setupOrderData(String[] args, Properties p) throws Exception {
        this.logTrace("setupOrderData");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupData() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.cleanup();
    }

    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        this.logTrace("in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                this.logTrace("Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    this.logTrace("Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            this.logTrace("Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        this.logErr("Did not get instance of Employee, instead got:" + o.getClass().getName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    this.logErr("Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    this.logTrace("rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            this.logTrace("Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    public boolean verifyListOfListEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    this.logTrace("Received expected result:");
                    for (Integer n : actual) {
                        this.logTrace("id:" + n);
                    }
                    ++count;
                    continue;
                }
                this.logErr("Did not receive expected result:");
                for (Integer n : expected) {
                    this.logErr(" Expected id:" + n);
                }
                for (Integer n : actual) {
                    this.logErr("Actual id:" + n);
                }
                continue;
            }
            this.logErr("Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            this.logErr("Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                this.logTrace("Received expected result:" + e);
            }
            result = true;
        } else {
            this.logErr("Did not receive expected result:");
            for (Employee e : expected) {
                this.logErr("expected employee:" + e);
            }
            for (Employee e : actual) {
                this.logErr("actual employee :" + e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void persistExceptionsTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing persisting an entity twice ");
        try {
            this.getEntityManager().detach((Object)this.orders[0]);
            this.getEntityTransaction().begin();
            this.logTrace("Try to persist an existing Order");
            this.getEntityManager().persist((Object)this.orders[0]);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.logErr("A PersistenceException was not thrown");
        }
        catch (EntityExistsException eee) {
            this.logTrace("EntityExistsException Caught as Expected:", eee);
            pass1 = true;
        }
        catch (PersistenceException pe) {
            this.logTrace("A PersistentException was caught:", pe);
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing non-entity ");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)this);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException caught as expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("persistExceptionsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Finding Order");
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.logTrace("Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.logTrace("Refreshing previous order");
            this.getEntityManager().refresh((Object)o);
            this.getEntityTransaction().commit();
            this.logErr("EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            this.logTrace("EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectMapEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)2);
            this.logTrace("Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.logTrace("Refreshing previous order");
            this.getEntityManager().refresh((Object)o, myMap);
            this.getEntityTransaction().commit();
            this.logErr("EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            this.logTrace("EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectMapEntityNotFoundExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectLockModeTypeEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)3);
            this.logTrace("Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            this.logTrace("Refreshing previous order");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            this.getEntityTransaction().commit();
            this.logErr("EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            this.logTrace("EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectLockModeTypeEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshRemovedObjectLockModeTypeMapEntityNotFoundExceptionTest() throws Exception {
        boolean pass = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.logTrace("Removing all data");
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            this.logTrace("Refreshing previous order");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            this.getEntityTransaction().commit();
            this.logErr("EntityNotFoundException not thrown");
        }
        catch (EntityNotFoundException e) {
            this.logTrace("EntityNotFoundException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("refreshRemovedObjectLockModeTypeMapEntityNotFoundExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                this.logTrace("Persisting order:" + o.toString());
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.emp0 = new Employee(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef.add(this.emp0);
            this.empRef.add(new Employee(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef.add(new Employee(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef.add(new Employee(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef.add(new Employee(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                this.logTrace("persisted employee:" + e);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
    }

    public void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

