/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.instance;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private int registeredProviderCnt = -1;
    private int registeredPropertyCnt = -1;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    public JAXRSClientIT() {
        this.setup();
        Client client = ClientBuilder.newClient();
        Configuration config = client.getConfiguration();
        this.registeredPropertyCnt = config.getProperties().size();
        this.registeredProviderCnt = config.getInstances().size();
        JAXRSClientIT.logMsg("Already registered", this.registeredProviderCnt, "providers");
        JAXRSClientIT.logMsg("Already registered", this.registeredPropertyCnt, "properties");
    }

    @Test
    public void defaultClientConfigurationPresetTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        this.checkConfig((Configurable<?>)client, this.registeredProviderCnt, this.registeredPropertyCnt);
    }

    @Test
    public void clientConfiguredTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        client.register((Object)new StringBeanEntityProvider());
        this.checkConfig((Configurable<?>)client, 1 + this.registeredProviderCnt, this.registeredPropertyCnt);
        client = ClientBuilder.newClient();
        client.property(this.getClass().getName(), (Object)this.getClass().getName());
        this.checkConfig((Configurable<?>)client, this.registeredProviderCnt, 1 + this.registeredPropertyCnt);
        client = ClientBuilder.newClient();
        client.register((Object)new Feature(){

            public boolean configure(FeatureContext context) {
                return true;
            }
        });
        this.checkConfig((Configurable<?>)client, 1 + this.registeredProviderCnt, this.registeredPropertyCnt);
    }

    void checkConfig(Configurable<?> configurable, int providersCount, int propertiesCount) throws JAXRSCommonClient.Fault {
        Configuration config = configurable.getConfiguration();
        Set providers = config.getInstances();
        boolean check = JAXRSClientIT.checkCollectionSize(providers, providersCount);
        Assertions.assertTrue((boolean)check, (String)("Unexpected Instances List in Client:" + providers.size()));
        TestUtil.logTrace("Test of Providers passed");
        Map properties = config.getProperties();
        check = JAXRSClientIT.checkCollectionSize(properties, propertiesCount);
        Assertions.assertTrue((boolean)check, (String)("Unexpected Properties List in Client:" + properties.size()));
        TestUtil.logTrace("Test of Properties passed");
    }

    static boolean checkCollectionSize(Collection<?> collection, int size) {
        return collection == null && size == 0 || collection != null && collection.size() == size;
    }

    static boolean checkCollectionSize(Map<?, ?> collection, int size) {
        return collection == null && size == 0 || collection != null && collection.size() == size;
    }
}

