/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.context;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.util.Property;

public final class GuiceContext
implements IContext {
    private final Injector injector;

    @Inject
    public GuiceContext(Injector injector) {
        if (injector == null) {
            throw new IllegalArgumentException();
        }
        this.injector = injector;
    }

    @Override
    public <T> T get(Property<T> property) {
        try {
            return (T)this.injector.getInstance(GuiceContext.getKey(property));
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    @Override
    public <T> T get(Class<T> clazz) {
        try {
            return (T)this.injector.getInstance(clazz);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    @Override
    public boolean containsKey(Property<?> property) {
        try {
            this.injector.getBinding(GuiceContext.getKey(property));
            return true;
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    @Override
    public boolean containsKey(Class<?> clazz) {
        try {
            this.injector.getBinding(clazz);
            return true;
        }
        catch (ConfigurationException e) {
            return false;
        }
    }

    private static <T> Key<T> getKey(Property<T> property) {
        Key key = Key.get((Type)property.getType(), (Annotation)Names.named((String)property.getName()));
        return key;
    }
}

