/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.search.HandlySearchResultUpdater;
import org.eclipse.handly.ui.search.QueryListenerAdapter;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractHandlySearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final Match[] NO_MATCHES = new Match[0];

    public AbstractHandlySearchResult(final HandlySearchResultUpdater updater) {
        if (updater != null) {
            final AbstractHandlySearchResult searchResult = this;
            NewSearchUI.addQueryListener((IQueryListener)new QueryListenerAdapter(){

                @Override
                public void queryFinished(ISearchQuery query) {
                    if (query.getSearchResult() == searchResult) {
                        updater.add(searchResult);
                    }
                }

                @Override
                public void queryRemoved(ISearchQuery query) {
                    if (query.getSearchResult() == searchResult) {
                        updater.remove(searchResult);
                        NewSearchUI.removeQueryListener((IQueryListener)this);
                    }
                }
            });
        }
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        ContainmentContext context = new ContainmentContext(this.getInputElementProvider().getElement(editorInput), ResourceUtil.getResource((IEditorInput)editorInput));
        if (context.isEmpty()) {
            return false;
        }
        ContainmentAdapter containmentAdapter = new ContainmentAdapter(this.getContentAdapter());
        return containmentAdapter.contains(context, match.getElement());
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        return this.computeContainedMatches(editor.getEditorInput());
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.computeContainedMatches((IEditorInput)new FileEditorInput(file));
    }

    public IFile getFile(Object element) {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else {
            IElement adapterElement = this.getContentAdapter().adapt(element);
            if (adapterElement != null) {
                resource = Elements.getResource((IElement)adapterElement);
            }
        }
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IContentAdapter getContentAdapter() {
        return NullContentAdapter.INSTANCE;
    }

    protected abstract IInputElementProvider getInputElementProvider();

    private Match[] computeContainedMatches(IEditorInput editorInput) {
        IElement element;
        ArrayList<Match> matches = new ArrayList<Match>();
        IResource resource = ResourceUtil.getResource((IEditorInput)editorInput);
        if (resource != null) {
            matches.addAll(Arrays.asList(this.getMatches(resource)));
        }
        if ((element = this.getInputElementProvider().getElement(editorInput)) != null) {
            this.collectContainedMatches(element, AbstractHandlySearchResult.into(matches));
        }
        return matches.toArray(NO_MATCHES);
    }

    private void collectContainedMatches(IElement element, Consumer<Match> acceptor) {
        block4: {
            Match[] matches;
            Match[] matchArray = matches = this.getMatches(this.getContentAdapter().getCorrespondingElement(element));
            int n = matches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                acceptor.accept(match);
                ++n2;
            }
            try {
                IElement[] children;
                IElement[] iElementArray = children = Elements.getChildren((IElement)element);
                int n3 = children.length;
                n = 0;
                while (n < n3) {
                    IElement child = iElementArray[n];
                    this.collectContainedMatches(child, acceptor);
                    ++n;
                }
            }
            catch (CoreException e) {
                if (!Elements.exists((IElement)element)) break block4;
                Activator.logError(e);
            }
        }
    }

    static <T> Consumer<T> into(Collection<T> c) {
        return t -> {
            boolean bl = c.add(t);
        };
    }

    static final class ContainmentAdapter {
        private final IContentAdapter contentAdapter;

        ContainmentAdapter(IContentAdapter contentAdapter) {
            this.contentAdapter = contentAdapter;
        }

        boolean contains(ContainmentContext context, Object element) {
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else {
                IElement adapterElement = this.contentAdapter.adapt(element);
                if (adapterElement != null) {
                    if (context.element != null) {
                        return Elements.isAncestorOf((IElement)context.element, (IElement)adapterElement);
                    }
                    resource = Elements.getResource((IElement)adapterElement);
                }
            }
            if (resource != null) {
                if (context.resource instanceof IFile) {
                    return resource.equals((Object)context.resource);
                }
                if (context.resource != null) {
                    return context.resource.getFullPath().isPrefixOf(resource.getFullPath());
                }
            }
            return false;
        }

        boolean isContainedInAnyOf(Object element, Iterable<ContainmentContext> contexts) {
            for (ContainmentContext context : contexts) {
                if (!this.contains(context, element)) continue;
                return true;
            }
            return false;
        }

        boolean exists(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).exists();
            }
            IElement adapterElement = this.contentAdapter.adapt(element);
            if (adapterElement != null) {
                return Elements.exists((IElement)adapterElement);
            }
            return false;
        }
    }

    static final class ContainmentContext {
        final IElement element;
        final IResource resource;

        ContainmentContext(IElement element, IResource resource) {
            this.element = element;
            this.resource = resource;
        }

        boolean isEmpty() {
            return this.element == null && this.resource == null;
        }
    }
}

