/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.docx;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.documents.AbstractImageService;
import org.eclipse.gendoc.documents.ImageDimension;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public class DOCXImageService
extends AbstractImageService {
    public void clear() {
    }

    public String manageImage(ITag tag, String imageId, String imagePath, boolean keepH, boolean keepW, boolean maxH, boolean maxW) throws AdditionalResourceException {
        String toInsert = "<v:imagedata xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" r:id=\"" + imageId + "\" o:title=\"\" />";
        String toInsertDraw = "<wpc:bg><a:blipFill><a:blip r:embed=\"" + imageId + "\"/><a:stretch><a:fillRect/></a:stretch></a:blipFill></wpc:bg>";
        StringBuffer newTagContent = new StringBuffer(tag.getRawText());
        try {
            Pattern p = Pattern.compile("<v:shape [^<>]*>");
            Matcher m = p.matcher(newTagContent);
            if (m.find()) {
                int index = m.end();
                newTagContent = newTagContent.insert(index, toInsert);
            }
            newTagContent = this.changeImageSize(newTagContent, imagePath, keepW, keepH, maxH, maxW);
            Pattern pDraw = Pattern.compile("<w:drawing>");
            Matcher mDraw = pDraw.matcher(newTagContent);
            if (mDraw.find()) {
                if (newTagContent.toString().contains("<wpc:bg/>")) {
                    newTagContent = new StringBuffer(newTagContent.toString().replaceAll("<wpc:bg/>", toInsertDraw));
                } else {
                    Pattern openWpcTag = Pattern.compile("<wpc:bg>.*</wpc:bg>", 40);
                    Matcher matcherOpenWpcTag = openWpcTag.matcher(newTagContent.toString());
                    if (matcherOpenWpcTag.find()) {
                        newTagContent = new StringBuffer(matcherOpenWpcTag.replaceAll(toInsertDraw));
                    } else {
                        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                        String tagIdDocx = (String)tag.getAttributes().get(RegisteredTags.ID);
                        logger.log("The execution of tag with id '" + tagIdDocx + "' is maybe erroneous : problems with insertion\n\tcould not replace <wpc:bg>\n" + newTagContent.toString(), 2);
                    }
                }
            }
            newTagContent = this.changeDrawingSize(newTagContent, imagePath, keepW, keepH, maxH, maxW);
        }
        catch (AdditionalResourceException e) {
            IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
            String tagIdDocx = (String)tag.getAttributes().get(RegisteredTags.ID);
            if (tagIdDocx == null) {
                throw e;
            }
            diagnostician.addDiagnostic(2, "The execution of tag with id '" + tagIdDocx + "' failed : Image cannot not be resized", null);
        }
        return newTagContent.toString().replaceFirst("editas=\"canvas\"", "");
    }

    private StringBuffer changeImageSize(StringBuffer tagContent, String imagePath, boolean keepW, boolean keepH, boolean maxH, boolean maxW) throws AdditionalResourceException {
        double width = 0.0;
        double height = 0.0;
        Pattern p = Pattern.compile("<v:group [^>]*>");
        Matcher m = p.matcher(tagContent);
        int widthStart = -1;
        int widthEnd = -1;
        int heightStart = -1;
        int heightEnd = -1;
        if (m.find()) {
            int start = m.start();
            String subString = m.group();
            p = Pattern.compile("width:[^;]*;");
            m = p.matcher(subString);
            if (m.find()) {
                widthStart = start + m.start();
                widthEnd = start + m.end();
            }
            if ((m = (p = Pattern.compile("height:[^;]*;")).matcher(subString)).find()) {
                heightStart = start + m.start();
                heightEnd = start + m.end();
            }
        }
        if (widthStart != -1) {
            String widthString = tagContent.substring(widthStart, widthEnd).replaceAll("(width:|;)", "");
            width = widthString.contains("pt") ? this.pointsToPixels(Double.parseDouble(widthString.replace("pt", ""))) : (widthString.contains("in") ? this.inchesToPixels(Double.parseDouble(widthString.replace("in", ""))) : Double.parseDouble(widthString));
        }
        if (heightStart != -1) {
            String heightString = tagContent.substring(heightStart, heightEnd).replaceAll("(height:|;)", "");
            height = heightString.contains("pt") ? this.pointsToPixels(Double.parseDouble(heightString.replace("pt", ""))) : (heightString.contains("in") ? this.inchesToPixels(Double.parseDouble(heightString.replace("in", ""))) : Double.parseDouble(heightString));
        }
        ImageDimension d = this.resizeImage(imagePath, width, height, keepH, keepW, maxH, maxW);
        if (heightStart != -1) {
            tagContent = tagContent.replace(heightStart, heightEnd, "height:" + d.getHeight() + ";");
        }
        if (widthStart != -1) {
            tagContent = tagContent.replace(widthStart, widthEnd, "width:" + d.getWidth() + ";");
        }
        return tagContent;
    }

    private double pointsToPixels(double dim) {
        return dim * 96.0 / 72.0;
    }

    private double emuToPixels(double dim) {
        return dim / 12700.0;
    }

    private int pixelsToEmu(double dim) {
        return new Double(dim * 20.0 * 635.0).intValue();
    }

    private StringBuffer changeDrawingSize(StringBuffer tagContent, String imagePath, boolean keepW, boolean keepH, boolean maxH, boolean maxW) throws AdditionalResourceException {
        double width = 0.0;
        double height = 0.0;
        Pattern p = Pattern.compile("<wp:extent [^>]*>");
        Matcher m = p.matcher(tagContent);
        int widthStart = -1;
        int widthEnd = -1;
        int heightStart = -1;
        int heightEnd = -1;
        if (m.find()) {
            int start = m.start();
            String subString = m.group();
            p = Pattern.compile("cx=\"[^\"]*\"");
            m = p.matcher(subString);
            if (m.find()) {
                widthStart = start + m.start();
                widthEnd = start + m.end();
            }
            if ((m = (p = Pattern.compile("cy=\"[^\"]*\"")).matcher(subString)).find()) {
                heightStart = start + m.start();
                heightEnd = start + m.end();
            }
        }
        if (widthStart != -1) {
            String widthString = tagContent.substring(widthStart + 4, widthEnd - 1);
            width = this.emuToPixels(Double.parseDouble(widthString));
        }
        if (heightStart != -1) {
            String heightString = tagContent.substring(heightStart + 4, heightEnd - 1);
            height = this.emuToPixels(Double.parseDouble(heightString));
        }
        ImageDimension d = this.resizeImage(imagePath, width, height, keepH, keepW, maxH, maxW);
        if (heightStart != -1) {
            tagContent = tagContent.replace(heightStart, heightEnd, "cy=\"" + this.pixelsToEmu(d.getHeight()) + "\"");
        }
        if (widthStart != -1) {
            tagContent = tagContent.replace(widthStart, widthEnd, "cx=\"" + this.pixelsToEmu(d.getWidth()) + "\"");
        }
        return tagContent;
    }
}

