/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;

class AbstractExtension {
    private final IConfigurationElement configElement;

    protected static void log(String message, Exception e) {
        ILogger loggerService = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        loggerService.log(message, 2);
    }

    protected AbstractExtension(IConfigurationElement configElement) {
        this.configElement = configElement;
    }

    protected IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    protected boolean parseBooleanAttribute(IConfigurationElement configElement, String attributeName, boolean isRequired) {
        boolean value = Boolean.parseBoolean(this.parseStringAttribute(configElement, attributeName, isRequired));
        return value;
    }

    protected String parseStringAttribute(IConfigurationElement configElement, String attributeName, boolean isRequired) {
        String value = configElement.getAttribute(attributeName);
        if (value != null) {
            return value;
        }
        if (isRequired) {
            throw new IllegalArgumentException("Required attribute " + attributeName + " was not found.");
        }
        return value;
    }
}

