/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.DocumentServiceException;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;

public class SaveProcess
extends AbstractProcess {
    protected void doRun() throws GenDocException {
        IDocumentManager documentManager = (IDocumentManager)GendocServices.getDefault().getService(IDocumentManager.class);
        Document document = documentManager.getDocTemplate();
        try {
            IConfigurationService configurationService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
            IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            documentService.saveDocument(document, configurationService.getOutput());
        }
        catch (DocumentServiceException documentServiceException) {
            IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
            diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(2, "org.eclipse.gendoc.parser", 0, "Error during document save", new Object[]{document}));
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Error during document save", 16);
        }
        catch (Exception t) {
            IGendocDiagnostician diag = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
            diag.addDiagnostic(2, "Error during document save : " + t.getMessage(), (Object)new Object[]{document});
        }
        this.worked(1);
    }

    protected int getTotalWork() {
        return 1;
    }
}

