/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.args;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.etrice.generator.base.args.Option;
import org.eclipse.etrice.generator.base.args.Options;

public class Arguments {
    private Options options;
    private LinkedHashMap<String, Object> option2Arg;

    public Arguments(Options options) {
        this.options = options;
        this.option2Arg = new LinkedHashMap();
    }

    public boolean hasArgument(String name) {
        return this.hasArgument(this.options.get(name));
    }

    public <T> boolean hasArgument(Option<T> option) {
        return this.option2Arg.containsKey(option.getName());
    }

    public Object get(String name) throws IllegalArgumentException {
        return this.get(this.options.get(name));
    }

    public <T> T get(Option<T> option) throws IllegalArgumentException {
        Object value = this.option2Arg.getOrDefault(option.getName(), option.getDefaultValue());
        return option.getType().cast(value);
    }

    public void set(String name, Object value) throws IllegalArgumentException {
        Option<?> opt = this.options.get(name);
        if (!opt.getType().isInstance(value)) {
            throw new IllegalArgumentException("value " + value.toString() + " is not assignable to Option " + opt.toString());
        }
        this.option2Arg.put(name, value);
    }

    public <T> void set(Option<T> option, T value) throws IllegalArgumentException {
        this.option2Arg.put(option.getName(), value);
    }

    public Options getOptions() {
        return this.options;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry<String, Object> entry : this.option2Arg.entrySet()) {
            joiner.add(this.argToString(entry.getKey(), entry.getValue()));
        }
        return joiner.toString();
    }

    private String argToString(String name, Object value) {
        String result = name + "=";
        if (value.getClass().isArray()) {
            Object[] arr = (Object[])value;
            result = result + Arrays.toString(arr);
        } else {
            result = result + value.toString();
        }
        return result;
    }
}

