/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Equation;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.java.CifWalker;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimAlgVariables
extends CifWalker
implements CifToCifTransformation {
    private final List<PositionObject> objectsToRemove = Lists.list();
    private final Map<AlgVariable, Expression> algVarValueMap = Maps.map();

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating algebraic variables from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        this.walkSpecification(spec);
        for (PositionObject obj : this.objectsToRemove) {
            EMFHelper.removeFromParentContainment((EObject)obj);
        }
    }

    private Expression getSingleValueForAlgVar(AlgVariable var) {
        Expression rslt = this.algVarValueMap.get(var);
        if (rslt != null) {
            return rslt;
        }
        rslt = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)var);
        this.algVarValueMap.put(var, rslt);
        return rslt;
    }

    protected void preprocessComplexComponent(ComplexComponent comp) {
        this.objectsToRemove.addAll(Lists.filter((List)comp.getDeclarations(), AlgVariable.class));
    }

    protected void preprocessEquation(Equation eqn) {
        if (eqn.getVariable() instanceof AlgVariable) {
            this.objectsToRemove.add((PositionObject)eqn);
        }
    }

    protected void walkAlgVariableExpression(AlgVariableExpression algRef) {
        AlgVariable var = algRef.getVariable();
        Expression value = this.getSingleValueForAlgVar(var);
        value = (Expression)EMFHelper.deepclone((EObject)value);
        EMFHelper.updateParentContainment((EObject)algRef, (EObject)value);
        this.walkExpression(value);
    }

    protected void preprocessSelfExpression(SelfExpression expr) {
        String msg = "Eliminating algebraic variables from a CIF specification with automaton \"self\" references is currently not supported.";
        throw new CifToCifPreconditionException(msg);
    }
}

