/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.generator.parser;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.setext.generator.parser.GrammarItem;
import org.eclipse.escet.setext.generator.parser.LALR1AutomatonState;
import org.eclipse.escet.setext.parser.ast.Symbol;

public class LR0AutomatonState {
    public final Set<GrammarItem> items;
    public int id = -1;
    public final Map<Symbol, LR0AutomatonState> edges = Maps.map();

    public LR0AutomatonState(Set<GrammarItem> items) {
        this.items = items;
        Assert.check((!items.isEmpty() ? 1 : 0) != 0);
    }

    public void addEdge(Symbol symbol, LR0AutomatonState state) {
        if (this.edges.containsKey(symbol)) {
            throw new IllegalStateException("Duplicate edge.");
        }
        this.edges.put(symbol, state);
    }

    public int hashCode() {
        return LR0AutomatonState.class.hashCode() ^ this.items.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LR0AutomatonState)) {
            return false;
        }
        LR0AutomatonState other = (LR0AutomatonState)obj;
        return this.items.equals(other.items);
    }

    public Set<GrammarItem> getKernelItems() {
        Set rslt = Sets.set();
        for (GrammarItem item : this.items) {
            if (!item.isKernelItem()) continue;
            rslt.add(item);
        }
        return rslt;
    }

    public LALR1AutomatonState toLALR1State() {
        Map newItems = Maps.map();
        for (GrammarItem item : this.items) {
            if (!item.isKernelItem()) continue;
            newItems.put(item, item.toLookaheadItem());
        }
        Assert.check((!newItems.isEmpty() ? 1 : 0) != 0);
        return new LALR1AutomatonState(newItems, this.id);
    }

    public List<Pair<Symbol, LR0AutomatonState>> getSortedEdges() {
        List sortedEdges = Lists.list();
        for (Map.Entry<Symbol, LR0AutomatonState> entry : this.edges.entrySet()) {
            sortedEdges.add(Pair.pair((Object)entry.getKey(), (Object)entry.getValue()));
        }
        Comparator<Pair<Symbol, LR0AutomatonState>> cmp = new Comparator<Pair<Symbol, LR0AutomatonState>>(){

            @Override
            public int compare(Pair<Symbol, LR0AutomatonState> t1, Pair<Symbol, LR0AutomatonState> t2) {
                int targetId1 = ((LR0AutomatonState)t1.right).id;
                int targetId2 = ((LR0AutomatonState)t2.right).id;
                if (targetId1 < targetId2) {
                    return -1;
                }
                if (targetId1 > targetId2) {
                    return 1;
                }
                return Strings.SORTER.compare(((Symbol)t1.left).name, ((Symbol)t2.left).name);
            }
        };
        Collections.sort(sortedEdges, cmp);
        return sortedEdges;
    }

    public void print(AppStream s, boolean initial, boolean skipEdges) {
        List charTxts = Lists.list();
        for (GrammarItem item : this.items) {
            charTxts.add(item.toString());
        }
        Collections.sort(charTxts, Strings.SORTER);
        s.println(Strings.fmt((String)"%sstate %d (%s):", (Object[])new Object[]{initial ? "initial " : "", this.id, charTxts}));
        if (skipEdges) {
            return;
        }
        List<Pair<Symbol, LR0AutomatonState>> edges = this.getSortedEdges();
        for (Pair<Symbol, LR0AutomatonState> edge : edges) {
            Symbol symbol = (Symbol)edge.left;
            LR0AutomatonState target = (LR0AutomatonState)edge.right;
            String edgeTxt = symbol.name + " -> " + target.id;
            s.println("  " + edgeTxt);
        }
    }
}

