/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2yed;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.cif.cif2yed.CifToYedModelDiagram;
import org.eclipse.escet.cif.cif2yed.CifToYedRelationsDiagram;
import org.eclipse.escet.cif.cif2yed.options.DiagramKind;
import org.eclipse.escet.cif.cif2yed.options.DiagramKindsOption;
import org.eclipse.escet.cif.cif2yed.options.ModelFiltersOption;
import org.eclipse.escet.cif.cif2yed.options.RelationKindsOption;
import org.eclipse.escet.cif.cif2yed.options.SyntaxHighlightingOption;
import org.eclipse.escet.cif.cif2yed.options.TransparentEdgeLabelsOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.XmlSupport;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.w3c.dom.Document;

public class CifToYedApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToYedApp app = new CifToYedApp();
        app.run(args, true);
    }

    public CifToYedApp() {
    }

    public CifToYedApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF to yEd transformer";
    }

    public String getAppDescription() {
        return "Transforms CIF files to yEd/GraphML (*.graphml) files.";
    }

    protected int runInternal() {
        Specification spec = (Specification)((CifReader)new CifReader().init()).read();
        String absSpecPath = Paths.resolve((String)InputFileOption.getPath());
        if (this.isTerminationRequested()) {
            return 0;
        }
        EnumSet<DiagramKind> kinds = DiagramKindsOption.getKinds();
        if (kinds.isEmpty()) {
            OutputProvider.warn((String)"No diagram kinds specified. No diagrams will be generated.");
        }
        if (OutputFileOption.getPath() != null && kinds.size() > 1) {
            String msg = "Writing multiple diagrams to a single explicitly specified output file is not supported. Use implicit/default output file names, or generate one diagram at a time.";
            throw new InvalidOptionException(msg);
        }
        for (DiagramKind kind : kinds) {
            String name = kind.toString().toLowerCase(Locale.US);
            String ext = Strings.fmt((String)".%s.graphml", (Object[])new Object[]{name});
            String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)ext);
            outPath = Paths.resolve((String)outPath);
            Termination termination = () -> this.isTerminationRequested();
            Document doc = null;
            try {
                switch (kind) {
                    case MODEL: {
                        doc = new CifToYedModelDiagram().transform(spec, absSpecPath, termination);
                        break;
                    }
                    case RELATIONS: {
                        doc = new CifToYedRelationsDiagram().transform(spec, absSpecPath, termination);
                    }
                }
            }
            catch (UnsupportedException ex) {
                String kindTxt = kind.getDescription();
                kindTxt = StringUtils.uncapitalize((String)kindTxt);
                String msg = Strings.fmt((String)"Failed to generate a yEd %s for CIF file \"%s\".", (Object[])new Object[]{kindTxt, InputFileOption.getPath()});
                throw new UnsupportedException(msg, (Throwable)ex);
            }
            Assert.notNull(doc);
            if (this.isTerminationRequested()) {
                return 0;
            }
            XmlSupport.writeFile((Document)doc, (String)"yEd", (String)outPath);
            if (!this.isTerminationRequested()) continue;
            return 0;
        }
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifToYedApp.getGeneralOptionCategory();
        List transOpts = Lists.list();
        transOpts.add(Options.getInstance(InputFileOption.class));
        transOpts.add(Options.getInstance(OutputFileOption.class));
        transOpts.add(Options.getInstance(DiagramKindsOption.class));
        transOpts.add(Options.getInstance(SyntaxHighlightingOption.class));
        transOpts.add(Options.getInstance(TransparentEdgeLabelsOption.class));
        transOpts.add(Options.getInstance(ModelFiltersOption.class));
        transOpts.add(Options.getInstance(RelationKindsOption.class));
        List transSubCats = Lists.list();
        OptionCategory transCat = new OptionCategory("Transformation", "Transformation options.", transSubCats, transOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, transCat});
        OptionCategory options = new OptionCategory("CIF to yEd Transformer Options", "All options for the CIF to yEd transformer.", cats, Lists.list());
        return options;
    }
}

