/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.declwrap;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.parser.ast.AAlgParameter;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypesTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.declwrap.DeclWrap;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class AlgParamDeclWrap
extends DeclWrap<AlgParameter> {
    private final AAlgParameter astDecl;

    public AlgParamDeclWrap(CifTypeChecker tchecker, ParentScope<?> scope, AAlgParameter astDecl, AlgParameter mmDecl) {
        super(tchecker, scope, mmDecl);
        this.astDecl = astDecl;
    }

    @Override
    public String getName() {
        return ((AlgParameter)this.mmDecl).getVariable().getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)((AlgParameter)this.mmDecl).getVariable());
    }

    @Override
    public void tcheckForUseImpl() {
        CifType type;
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            type = CifTypesTypeChecker.transCifType(this.astDecl.type, this.scope.getParent(), this.tchecker);
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        if (CifTypeUtils.hasComponentLikeType((CifType)type)) {
            this.tchecker.addProblem(ErrMsg.DECL_INVALID_TYPE, type.getPosition(), "Algebraic parameter", this.getAbsName(), CifTextUtils.typeToStr((CifType)type));
            throw new SemanticException();
        }
        ((AlgParameter)this.mmDecl).getVariable().setType(type);
        this.status = CheckStatus.USE;
    }

    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.astDecl.annotations, this.scope, this.tchecker);
        ((AlgParameter)this.mmDecl).getVariable().getAnnotations().addAll(annos);
        CifType type = ((AlgParameter)this.mmDecl).getVariable().getType();
        if (CifValueUtils.getPossibleValueCount((CifType)type) == 1.0) {
            this.tchecker.addProblem(ErrMsg.TYPE_ONE_VALUE, type.getPosition(), "", CifTextUtils.typeToStr((CifType)type), "algebraic parameter", CifTextUtils.getAbsName((PositionObject)this.mmDecl, (boolean)false), "algebraic parameter");
        }
        this.status = CheckStatus.FULL;
    }
}

