/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class Labels {
    private static final String REQUIREMENT_GROUP_PREFIX = "RG";
    private static final String PLANT_GROUP_PREFIX = "PG";

    private Labels() {
    }

    public static Label makePlantGroupLabel(int n) {
        return new Label(PLANT_GROUP_PREFIX + Integer.toString(n + 1));
    }

    public static Label makeRequirementGroupLabel(int n) {
        return new Label(REQUIREMENT_GROUP_PREFIX + Integer.toString(n + 1));
    }

    public static Label makeLabel(PositionObject element) {
        if (element instanceof Automaton) {
            Automaton aut = (Automaton)element;
            return new AutomatonLabel(aut);
        }
        if (element instanceof Invariant) {
            Invariant inv = (Invariant)element;
            return new InvariantLabel(inv);
        }
        if (element instanceof InputVariable) {
            InputVariable inpVar = (InputVariable)element;
            return new InputVarLabel(inpVar);
        }
        if (element instanceof DiscVariable) {
            DiscVariable discVar = (DiscVariable)element;
            return new DiscVarLabel(discVar);
        }
        if (element instanceof Event) {
            Event event = (Event)element;
            return new EventLabel(event);
        }
        if (element instanceof Location) {
            Location loc = (Location)element;
            return new LocationLabel(loc);
        }
        throw new AssertionError((Object)("Unexpected position object class encountered: " + String.valueOf(element)));
    }

    public static PositionObject unwrapLabel(Label label) {
        if (label instanceof AutomatonLabel) {
            AutomatonLabel autLabel = (AutomatonLabel)label;
            return autLabel.automaton;
        }
        if (label instanceof InvariantLabel) {
            InvariantLabel invLabel = (InvariantLabel)label;
            return invLabel.invariant;
        }
        if (label instanceof InputVarLabel) {
            InputVarLabel inpVarLabel = (InputVarLabel)label;
            return inpVarLabel.inputVar;
        }
        if (label instanceof DiscVarLabel) {
            DiscVarLabel discVarLabel = (DiscVarLabel)label;
            return discVarLabel.discVar;
        }
        if (label instanceof EventLabel) {
            EventLabel eventLabel = (EventLabel)label;
            return eventLabel.event;
        }
        if (label instanceof LocationLabel) {
            LocationLabel locLabel = (LocationLabel)label;
            return locLabel.location;
        }
        throw new AssertionError((Object)("Unexpected label class encountered: " + String.valueOf(label)));
    }

    public static class AutomatonLabel
    extends Label {
        public final Automaton automaton;

        public AutomatonLabel(Automaton automaton) {
            super(CifTextUtils.getAbsName((PositionObject)automaton, (boolean)false));
            this.automaton = automaton;
        }
    }

    public static class DiscVarLabel
    extends Label {
        public final DiscVariable discVar;

        public DiscVarLabel(DiscVariable discVar) {
            super(CifTextUtils.getAbsName((PositionObject)discVar, (boolean)false));
            this.discVar = discVar;
        }
    }

    public static class EventLabel
    extends Label {
        public final Event event;

        public EventLabel(Event event) {
            super(CifTextUtils.getAbsName((PositionObject)event, (boolean)false));
            this.event = event;
        }
    }

    public static class InputVarLabel
    extends Label {
        public final InputVariable inputVar;

        public InputVarLabel(InputVariable inputVar) {
            super(CifTextUtils.getAbsName((PositionObject)inputVar, (boolean)false));
            this.inputVar = inputVar;
        }
    }

    public static class InvariantLabel
    extends Label {
        public final Invariant invariant;

        public InvariantLabel(Invariant invariant) {
            super(invariant.getName() == null ? CifTextUtils.invToStr((Invariant)invariant, (boolean)true) : CifTextUtils.getAbsName((PositionObject)invariant, (boolean)false));
            this.invariant = invariant;
        }
    }

    public static class LocationLabel
    extends Label {
        public final Location location;

        public LocationLabel(Location location) {
            super(CifTextUtils.getLocationText1((Location)location));
            this.location = location;
        }
    }
}

