/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class ExponentialDistribution
extends DoubleDistribution {
    private RandomGenerator randGen;
    private double mean;

    public ExponentialDistribution(ChiCoordinator chiCoordinator, double mean) {
        super(chiCoordinator);
        if (mean <= 0.0) {
            String msg = Strings.fmt((String)"The Exponential distribution expects the mean parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{mean});
            throw new ChiSimulatorException(msg);
        }
        this.mean = mean;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return ExponentialDistribution.drawExponential(this.randGen, this.mean);
    }

    public static double drawExponential(RandomGenerator randGen, double mean) {
        return -mean * Math.log(1.0 - randGen.draw());
    }
}

