/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.gmfgraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LineKind implements Enumerator
{
    LINE_SOLID_LITERAL(1, "LINE_SOLID", "LINE_SOLID"),
    LINE_DASH_LITERAL(2, "LINE_DASH", "LINE_DASH"),
    LINE_DOT_LITERAL(3, "LINE_DOT", "LINE_DOT"),
    LINE_DASHDOT_LITERAL(4, "LINE_DASHDOT", "LINE_DASHDOT"),
    LINE_DASHDOTDOT_LITERAL(5, "LINE_DASHDOTDOT", "LINE_DASHDOTDOT"),
    LINE_CUSTOM_LITERAL(6, "LINE_CUSTOM", "LINE_CUSTOM");

    public static final int LINE_SOLID = 1;
    public static final int LINE_DASH = 2;
    public static final int LINE_DOT = 3;
    public static final int LINE_DASHDOT = 4;
    public static final int LINE_DASHDOTDOT = 5;
    public static final int LINE_CUSTOM = 6;
    private static final LineKind[] VALUES_ARRAY;
    public static final List<LineKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LineKind[]{LINE_SOLID_LITERAL, LINE_DASH_LITERAL, LINE_DOT_LITERAL, LINE_DASHDOT_LITERAL, LINE_DASHDOTDOT_LITERAL, LINE_CUSTOM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LineKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LineKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LineKind get(int value) {
        switch (value) {
            case 1: {
                return LINE_SOLID_LITERAL;
            }
            case 2: {
                return LINE_DASH_LITERAL;
            }
            case 3: {
                return LINE_DOT_LITERAL;
            }
            case 4: {
                return LINE_DASHDOT_LITERAL;
            }
            case 5: {
                return LINE_DASHDOTDOT_LITERAL;
            }
            case 6: {
                return LINE_CUSTOM_LITERAL;
            }
        }
        return null;
    }

    private LineKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

