/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util.collection;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.operations.SimulinkCollectOperation;
import org.eclipse.epsilon.emc.simulink.operations.SimulinkSelectOperation;
import org.eclipse.epsilon.emc.simulink.util.collection.AbstractElementIterator;
import org.eclipse.epsilon.emc.simulink.util.collection.AbstractListIterator;
import org.eclipse.epsilon.emc.simulink.util.collection.AbstractSimulinkCollection;
import org.eclipse.epsilon.emc.simulink.util.manager.Manager;
import org.eclipse.epsilon.emc.simulink.util.manager.SimulinkBlockManager;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ExistsOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FindOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FindOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.FirstOrderOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.ForAllOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.IAbstractOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.declarative.RejectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.RejectOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOneOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.SortByOperation;

public class SimulinkBlockCollection
extends AbstractSimulinkCollection<SimulinkBlock, Double, SimulinkBlockManager>
implements IAbstractOperationContributor {
    public SimulinkBlockCollection(Object primitive, SimulinkModel model) {
        super(primitive, (Manager)new SimulinkBlockManager(model));
    }

    protected boolean isInstanceOf(Object object) {
        return object instanceof SimulinkBlock;
    }

    protected boolean isInstanceOfPrimitive(Object object) {
        return object instanceof Double;
    }

    protected boolean isInstanceOfPrimitiveArray(Object object) {
        if (object instanceof Double[]) {
            return true;
        }
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object).stream().allMatch(h -> this.isInstanceOfPrimitive(h));
        }
        return false;
    }

    public List<ISimulinkModelElement> subList(int fromIndex, int toIndex) {
        return new SimulinkBlockCollection(this.getPrimitive().subList(fromIndex, toIndex), ((SimulinkBlockManager)this.getManager()).getModel());
    }

    public ListIterator<ISimulinkModelElement> listIterator() {
        return new SimulinkBlockListIterator();
    }

    public ListIterator<ISimulinkModelElement> listIterator(int index) {
        return new SimulinkBlockListIterator(index);
    }

    protected Iterator<ISimulinkModelElement> getInternalIterator() {
        return new SimulinkBlockIterator();
    }

    public AbstractOperation getAbstractOperation(String name) {
        block34: {
            SimulinkModel model = ((SimulinkBlockManager)this.getManager()).getModel();
            if (!model.isFindOptimisationEnabled()) break block34;
            switch (name) {
                case "select": {
                    return new SimulinkSelectOperation(model);
                }
                case "collect": {
                    return new SimulinkCollectOperation(model.getEngine());
                }
                case "exists": {
                    ExistsOperation existsOperation = new ExistsOperation();
                    existsOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return existsOperation;
                }
                case "findOne": {
                    FindOneOperation findOneOperation = new FindOneOperation();
                    findOneOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return findOneOperation;
                }
                case "find": {
                    FindOperation findOperation = new FindOperation();
                    findOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return findOperation;
                }
                case "forAll": {
                    ForAllOperation forAllOperation = new ForAllOperation();
                    forAllOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return forAllOperation;
                }
                case "rejectOne": {
                    RejectOneOperation rejectOneOperation = new RejectOneOperation();
                    rejectOneOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return rejectOneOperation;
                }
                case "reject": {
                    RejectOperation rejectOperation = new RejectOperation();
                    rejectOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return rejectOperation;
                }
                case "selectOne": {
                    SelectOneOperation selectOneOperation = new SelectOneOperation();
                    selectOneOperation.setDelegateOperation((FirstOrderOperation)new SimulinkSelectOperation(model));
                    return selectOneOperation;
                }
                case "sortBy": {
                    SortByOperation sortByOperation = new SortByOperation();
                    sortByOperation.setDelegateOperation((FirstOrderOperation)new SimulinkCollectOperation(model.getEngine()));
                    return sortByOperation;
                }
            }
        }
        return null;
    }

    protected class SimulinkBlockIterator
    extends AbstractElementIterator<SimulinkBlock, Double, SimulinkBlockManager> {
        SimulinkBlockIterator() {
            super(SimulinkBlockCollection.this.getPrimitive(), (Manager)((SimulinkBlockManager)SimulinkBlockCollection.this.getManager()));
        }
    }

    protected class SimulinkBlockListIterator
    extends AbstractListIterator<SimulinkBlock, Double, SimulinkBlockManager> {
        SimulinkBlockListIterator() {
            super(SimulinkBlockCollection.this.getPrimitive(), (Manager)((SimulinkBlockManager)SimulinkBlockCollection.this.getManager()));
        }

        SimulinkBlockListIterator(int index) {
            super(index, SimulinkBlockCollection.this.getPrimitive(), (Manager)((SimulinkBlockManager)SimulinkBlockCollection.this.getManager()));
        }
    }
}

