/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.IdentifiableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class CollectionSliceReference
extends IdentifiableReference<Collection<Object>> {
    private final String name;
    private final int from;
    private final int to;
    private List<Object> internalList;

    public CollectionSliceReference(IEolContext context, String name, Collection<Object> t, int from, int to) {
        super(context, t);
        if (from < 0) {
            throw new IllegalArgumentException("from cannot be negative");
        }
        if (to > t.size()) {
            throw new IllegalArgumentException(String.format("to cannot exceed the size of the collection: %d > %d", to, t.size()));
        }
        this.name = name;
        this.from = from;
        this.to = to;
    }

    @Override
    public String getName() {
        return String.format("%s[%d..%d]", this.name, this.from, this.to - 1);
    }

    @Override
    public String getValue() {
        return String.format("<slice with %d elements>", this.to - this.from);
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        ArrayList<IVariableReference> refs = new ArrayList<IVariableReference>(this.to - this.from);
        List<Object> l = null;
        l = this.target instanceof List ? ((List)this.target).subList(this.from, this.to) : this.getInternalList();
        int i = this.from;
        for (Object e : l) {
            refs.add(state.getValueReference(this.context, String.format("%s[%d]", this.name, i++), e));
        }
        return refs;
    }

    protected synchronized List<Object> getInternalList() {
        if (this.internalList == null) {
            this.internalList = new ArrayList<Object>(this.to - this.from);
            Iterator it = ((Collection)this.target).iterator();
            int i = 0;
            while (i < this.from) {
                it.next();
                ++i;
            }
            while (i < this.to) {
                this.internalList.add(it.next());
                ++i;
            }
        }
        return this.internalList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.from, this.name, this.to);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollectionSliceReference other = (CollectionSliceReference)obj;
        return this.from == other.from && Objects.equals(this.name, other.name) && this.to == other.to;
    }
}

