/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.loader;

import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassLoaderFactory {
    private JavaClassLoaderFactory() {
    }

    public static URL getURL(IPath location) {
        IPath path = location;
        if (path == null) {
            return null;
        }
        try {
            if (path.toFile() != null && path.toFile().isAbsolute()) {
                return new URL(path.toFile().toURI().toURL().toExternalForm());
            }
        }
        catch (Throwable t) {
            EGFCommonPlugin.getDefault().logWarning(t);
        }
        return null;
    }

    public static List<URL> getURLs(IJavaProject project) throws CoreException {
        return JavaClassLoaderFactory.getURLs(project, (List<IJavaProject>)new UniqueEList());
    }

    public static List<URL> getURLs(IJavaProject project, List<IJavaProject> visited) throws CoreException {
        UniqueEList urls = new UniqueEList();
        if (project == null) {
            return urls;
        }
        if (visited != null && visited.contains(project)) {
            return urls;
        }
        try {
            IFolder folder;
            URL url = JavaClassLoaderFactory.getURL(project.getProject().getLocation());
            if (url != null) {
                urls.add(url);
            }
            if ((folder = FileHelper.getFolder(project.getOutputLocation())) != null && (url = JavaClassLoaderFactory.getURL(folder.getLocation())) != null) {
                urls.add(url);
            }
            IClasspathEntry[] iClasspathEntryArray = project.getResolvedClasspath(true);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject innerJavaProject;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    folder = FileHelper.getFolder(entry.getOutputLocation());
                    if (folder != null && (url = JavaClassLoaderFactory.getURL(folder.getLocation())) != null) {
                        urls.add(url);
                    }
                } else if (entry.getEntryKind() == 1) {
                    url = JavaClassLoaderFactory.getURL(entry.getPath());
                    if (url != null) {
                        urls.add(url);
                    }
                } else if (entry.getEntryKind() == 4) {
                    url = JavaClassLoaderFactory.getURL(entry.getPath());
                    if (url != null) {
                        urls.add(url);
                    }
                } else if (entry.getEntryKind() == 5) {
                    IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    if (classpathContainer != null) {
                        IClasspathEntry[] iClasspathEntryArray2 = classpathContainer.getClasspathEntries();
                        int n3 = iClasspathEntryArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaProject innerJavaProject2;
                            IClasspathEntry innerEntry = iClasspathEntryArray2[n4];
                            if (innerEntry.getEntryKind() == 1) {
                                url = JavaClassLoaderFactory.getURL(innerEntry.getPath());
                                if (url != null) {
                                    urls.add(url);
                                }
                            } else if (innerEntry.getEntryKind() == 2 && (innerJavaProject2 = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(innerEntry.getPath().toString()))) != null && innerJavaProject2.exists() && innerJavaProject2.isOpen()) {
                                urls.addAll(JavaClassLoaderFactory.getURLs(innerJavaProject2, visited));
                            }
                            ++n4;
                        }
                    }
                } else if (entry.getEntryKind() == 2 && (innerJavaProject = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().toString()))) != null && innerJavaProject.exists() && innerJavaProject.isOpen()) {
                    urls.addAll(JavaClassLoaderFactory.getURLs(innerJavaProject, visited));
                }
                ++n2;
            }
            if (visited != null) {
                visited.add(project);
            }
        }
        catch (Throwable t) {
            throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCommonMessages.JavaProject_AnalysisFailure, (Object)project.getProject().getName()), t));
        }
        return urls;
    }
}

