/*******************************************************************************
 * Copyright (c) 2015 BestSolution.at and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v.2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Tom Schindl<tom.schindl@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.core.internal.sm;

import java.util.HashMap;
import java.util.Map;

import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import javax.xml.namespace.QName;

/**
 * Properties model
 */
public class Properties {
	private String entry;
	private Map<QName, String> otherAttributes = new HashMap<>();

	/**
	 * @return the entry path
	 */
	@XmlAttribute
	public String getEntry() {
		return this.entry;
	}

	/**
	 * Set the entry path
	 * @param entry the entry path
	 */
	public void setEntry(String entry) {
		this.entry = entry;
	}

	@XmlAnyAttribute
    public Map<QName, String> getOtherAttributes() {
		return this.otherAttributes;
	}
	
	public void setOtherAttributes(Map<QName, String> otherAttributes) {
		this.otherAttributes = otherAttributes;
	}
}
