/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class AgentRemoteClassData {
    private String className;
    private String codeSource;
    private byte[] byteData;
    static final AgentRemoteClassData NO_CLASS_DATA = new AgentRemoteClassData();

    private AgentRemoteClassData() {
    }

    AgentRemoteClassData(String className, String codeSource, byte[] byteData) {
        this.className = className;
        this.codeSource = codeSource;
        this.byteData = byteData;
    }

    AgentRemoteClassData(DataInputStream in) throws IOException, ClassNotFoundException {
        int n;
        this.className = in.readUTF();
        if (this.className == null || this.className.isEmpty()) {
            throw new ClassNotFoundException("no class data in the InputStream");
        }
        this.codeSource = in.readUTF();
        int size = in.readInt();
        if (size == 0) {
            throw new ClassNotFoundException(this.className);
        }
        this.byteData = new byte[size];
        for (int offset = 0; offset < this.byteData.length; offset += n) {
            n = in.read(this.byteData, offset, this.byteData.length - offset);
            if (n != -1) continue;
            throw new ClassNotFoundException(this.className + ": EOF while reading class data");
        }
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.className == null || this.className.isEmpty() || this.byteData == null || this.byteData.length == 0) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.className);
            out.writeUTF(this.codeSource);
            out.writeInt(this.byteData.length);
            out.write(this.byteData, 0, this.byteData.length);
        }
    }

    public String getCodeSource() {
        return this.codeSource;
    }

    public byte[] getByteData() {
        return this.byteData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" {").append(" className: ").append(this.className).append(" codeSource: ").append(this.codeSource).append(" data.length: ").append(this.byteData == null ? 0 : this.byteData.length).append(" }");
        return sb.toString();
    }
}

