/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.krazo.binding.convert.MvcConverter;
import org.eclipse.krazo.util.ServiceLoaders;

@ApplicationScoped
public class ConverterRegistry {
    private final List<MvcConverter> converters = new ArrayList<MvcConverter>();

    @PostConstruct
    public void init() {
        this.converters.addAll(ServiceLoaders.list(MvcConverter.class));
    }

    public <T> MvcConverter<T> lookup(Class<T> rawType, Annotation[] annotations) {
        return this.converters.stream().filter(converter -> converter.supports(rawType, annotations)).findFirst().orElse(null);
    }
}

