/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.InvocationHandlerUtil;
import com.sun.ejb.containers.interceptors.AroundInvokeInvocationContext;
import com.sun.ejb.containers.interceptors.InterceptorManager;
import com.sun.enterprise.container.common.spi.InterceptorInvoker;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class InterceptorInvocationHandler
implements InvocationHandler,
InterceptorInvoker {
    private Object targetInstance;
    private Object clientProxy;
    private Object[] interceptorInstances;
    private InterceptorManager interceptorManager;
    private static Object[] emptyArray = new Object[0];

    public void init(Object targetInstance, Object[] interceptorInstances, Object clientProxy, InterceptorManager manager) {
        this.targetInstance = targetInstance;
        this.interceptorInstances = interceptorInstances;
        this.clientProxy = clientProxy;
        this.interceptorManager = manager;
    }

    public Object getProxy() {
        return this.clientProxy;
    }

    public Object getTargetInstance() {
        return this.targetInstance;
    }

    public Object[] getInterceptorInstances() {
        return this.interceptorInstances;
    }

    public void invokeAroundConstruct() throws Exception {
        this.invokeCallback(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT);
        this.targetInstance = this.interceptorManager.getTargetInstance();
    }

    public void invokePostConstruct() throws Exception {
        this.invokeCallback(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT);
    }

    public void invokePreDestroy() throws Exception {
        this.invokeCallback(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY);
    }

    private void invokeCallback(LifecycleCallbackDescriptor.CallbackType type) throws Exception {
        try {
            this.interceptorManager.intercept(type, this.targetInstance, this.interceptorInstances);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> methodClass = method.getDeclaringClass();
        if (methodClass == Object.class) {
            return InvocationHandlerUtil.invokeJavaObjectMethod(this, method, args);
        }
        Object returnValue = null;
        try {
            Method beanClassMethod = this.targetInstance.getClass().getMethod(method.getName(), method.getParameterTypes());
            InterceptorManager.InterceptorChain chain = this.interceptorManager.getAroundInvokeChain(null, beanClassMethod);
            Object[] theArgs = args == null ? emptyArray : args;
            AroundInvokeInvocationContext invContext = new AroundInvokeInvocationContext(this.targetInstance, this.interceptorInstances, chain, beanClassMethod, theArgs);
            returnValue = this.interceptorManager.intercept(chain, invContext);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        return returnValue;
    }

    public String toString() {
        return this.targetInstance != null ? this.targetInstance.toString() : super.toString();
    }
}

