/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import java.util.Objects;

final class RenderKitUtil {
    private RenderKitUtil() {
        throw new AssertionError();
    }

    public static RenderKit getRenderKit(FacesContext facesContext, String renderKitId) {
        Objects.requireNonNull(facesContext);
        Objects.requireNonNull(renderKitId);
        RenderKit renderKit = facesContext.getRenderKit();
        if (renderKit == null) {
            RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
            if (renderKitFactory == null) {
                throw new FacesException("Unable to locate factory for jakarta.faces.render.RenderKitFactory");
            }
            renderKit = renderKitFactory.getRenderKit(facesContext, renderKitId);
            if (renderKit == null) {
                UIViewRoot viewRoot = facesContext.getViewRoot();
                if (viewRoot != null) {
                    viewRoot.setRenderKitId("HTML_BASIC");
                }
                if ((renderKit = renderKitFactory.getRenderKit(facesContext, "HTML_BASIC")) == null) {
                    throw new FacesException("Unable to locate render kit instance for HTML_BASIC");
                }
            }
        }
        return renderKit;
    }
}

