/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Singleton;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AuthTokenManager {
    public static final String AUTH_TOKEN_OPTION_NAME = "_authtoken";
    private static final String SUPPRESSED_TOKEN_OUTPUT = "????";
    private static final int TOKEN_SIZE = 10;
    private static final long DEFAULT_TOKEN_LIFETIME = 60000L;
    private final SecureRandom rng = new SecureRandom();
    private final Map<String, TokenInfo> liveTokens = new HashMap<String, TokenInfo>();
    private static final Logger logger = CULoggerInfo.getLogger();
    private static final char REUSE_TOKEN_MARKER = '+';
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AuthTokenManager.class);
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String createToken(Subject subject, long lifetime) {
        byte[] newToken = new byte[10];
        this.rng.nextBytes(newToken);
        String token = AuthTokenManager.toHex(newToken);
        this.liveTokens.put(token, new TokenInfo(subject, token, lifetime));
        logger.log(Level.FINER, "Auth token {0} created", token);
        return token;
    }

    public String createToken() {
        return this.createToken(60000L);
    }

    public String createToken(Subject subject) {
        return this.createToken(subject, 60000L);
    }

    public String createToken(long lifetime) {
        return this.createToken(new Subject(), lifetime);
    }

    public Subject findToken(String token) {
        TokenInfo ti = this.findTokenInfo(token, System.currentTimeMillis());
        return ti != null ? ti.subject : null;
    }

    private TokenInfo findTokenInfo(String token, long now) {
        int firstReuseMarker = token.indexOf(43);
        String tokenAsRecorded = this.isReusedToken(token) ? token.substring(0, firstReuseMarker) : token;
        TokenInfo ti = this.liveTokens.get(tokenAsRecorded);
        if (ti == null) {
            logger.log(Level.WARNING, "NCLS-COMUTIL-00039", logger.isLoggable(Level.FINER) ? tokenAsRecorded : SUPPRESSED_TOKEN_OUTPUT);
            return null;
        }
        return ti.isOKTouse(now) ? ti : null;
    }

    public Subject consumeToken(String token) {
        Subject result = null;
        long now = System.currentTimeMillis();
        TokenInfo ti = this.findTokenInfo(token, now);
        if (ti != null && ti.use(this.isReusedToken(token), now)) {
            result = ti.subject;
        }
        this.retireExpiredTokens(now);
        return result;
    }

    private boolean isReusedToken(String token) {
        return token.indexOf(43) != -1;
    }

    public Subject subject(String token) {
        TokenInfo ti = this.liveTokens.get(token);
        return ti != null ? ti.subject : null;
    }

    public static String markTokenForReuse(String token) {
        return token + "+";
    }

    private synchronized void retireExpiredTokens(long now) {
        Iterator<Map.Entry<String, TokenInfo>> it = this.liveTokens.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, TokenInfo> entry = it.next();
            if (!entry.getValue().isUsedUp(now)) continue;
            logger.log(Level.FINER, "Auth token {0} being retired during scan", entry.getValue().token);
            it.remove();
        }
    }

    private static String toHex(byte[] b) {
        char[] bc = new char[b.length * 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            byte bb = b[i];
            bc[j++] = hex[bb >> 4 & 0xF];
            bc[j++] = hex[bb & 0xF];
        }
        return new String(bc);
    }

    private static class TokenInfo {
        private final String token;
        private int usesRemaining = 2;
        private long expiration;
        private final long lifetime;
        private final Subject subject;

        private TokenInfo(Subject subject, String value, long lifetime) {
            this.subject = subject;
            this.token = value;
            this.lifetime = lifetime;
            this.expiration = System.currentTimeMillis() + lifetime;
        }

        private synchronized boolean isOKTouse(long now) {
            return !this.isUsedUp(now);
        }

        private synchronized boolean use(boolean isBeingReused, long now) {
            if (this.isUsedUp(now)) {
                if (logger.isLoggable(Level.FINER)) {
                    String msg = localStrings.getLocalString("AuthTokenInvalid", "Use of auth token {2} attempted but token is invalid; usesRemaining = {0,number,integer}, expired = {1}", this.usesRemaining, Boolean.toString(this.expiration <= now), this.token);
                    logger.log(Level.FINER, msg);
                }
                return false;
            }
            if (!isBeingReused) {
                --this.usesRemaining;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Use of auth token {0} OK; isBeingReused = {2}; remaining uses = {1,number,integer}", new Object[]{this.token, this.usesRemaining, Boolean.toString(isBeingReused)});
            }
            this.expiration += this.lifetime;
            return true;
        }

        private boolean isUsedUp(long now) {
            return this.usesRemaining <= 0 || this.expiration <= now;
        }
    }
}

