/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ConnectorConnectionPool
implements Serializable {
    private static final long serialVersionUID = 1405898931936731912L;
    public static final String DEFAULT_MAX_CONNECTION_USAGE = "0";
    public static final String DEFAULT_CON_CREATION_RETRY_ATTEMPTS = "0";
    public static final String DEFAULT_CON_CREATION_RETRY_INTERVAL = "10";
    public static final String DEFAULT_VALIDATE_ATMOST_ONCE_PERIOD = "0";
    public static final String DEFAULT_LEAK_TIMEOUT = "0";
    private static final Logger LOG = LogDomains.getLogger(ConnectorConnectionPool.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected ConnectorDescriptorInfo connectorDescriptorInfo;
    protected String steadyPoolSize;
    protected String maxPoolSize;
    protected String maxWaitTimeInMillis;
    protected String poolResizeQuantity;
    protected String idleTimeoutInSeconds;
    protected boolean failAllConnections;
    protected boolean matchConnections;
    protected int transactionSupport;
    protected boolean isConnectionValidationRequired;
    private boolean lazyConnectionAssoc;
    private boolean lazyConnectionEnlist;
    private boolean associateWithThread;
    private boolean partitionedPool;
    private boolean poolingOn = true;
    private boolean pingDuringPoolCreation;
    private String poolDataStructureType;
    private String poolWaitQueue;
    private String dataStructureParameters;
    private String resourceGatewayClass;
    private boolean nonTransactional;
    private boolean nonComponent;
    private long dynamicReconfigWaitTimeout;
    private ConnectorSecurityMap[] securityMaps;
    private boolean isAuthCredentialsDefinedInPool;
    private String maxConnectionUsage;
    private boolean validateAtmostEveryIdleSecs;
    private boolean preferValidateOverRecreate;
    private String validateAtmostOncePeriod;
    private String conCreationRetryAttempts;
    private String conCreationRetryInterval;
    private String connectionLeakTracingTimeout;
    private boolean connectionReclaim;
    private final SimpleJndiName name;
    private String applicationName;
    private String moduleName;

    public ConnectorConnectionPool(PoolInfo poolInfo) {
        this.name = poolInfo.getName();
        this.applicationName = poolInfo.getApplicationName();
        this.moduleName = poolInfo.getModuleName();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isApplicationScopedResource() {
        return this.applicationName != null;
    }

    public boolean getPingDuringPoolCreation() {
        return this.pingDuringPoolCreation;
    }

    public void setPingDuringPoolCreation(boolean enabled) {
        this.pingDuringPoolCreation = enabled;
    }

    public boolean isPoolingOn() {
        return this.poolingOn;
    }

    public void setPooling(boolean enabled) {
        this.poolingOn = enabled;
    }

    public SimpleJndiName getName() {
        return this.name;
    }

    public void setAuthCredentialsDefinedInPool(boolean authCred) {
        this.isAuthCredentialsDefinedInPool = authCred;
    }

    public boolean getAuthCredentialsDefinedInPool() {
        return this.isAuthCredentialsDefinedInPool;
    }

    public ConnectorDescriptorInfo getConnectorDescriptorInfo() {
        return this.connectorDescriptorInfo;
    }

    public void setConnectorDescriptorInfo(ConnectorDescriptorInfo connectorDescriptorInfo) {
        this.connectorDescriptorInfo = connectorDescriptorInfo;
    }

    public String getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    public void setSteadyPoolSize(String steadyPoolSize) {
        this.steadyPoolSize = steadyPoolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis;
    }

    public void setMaxWaitTimeInMillis(String maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis = maxWaitTimeInMillis;
    }

    public String getPoolResizeQuantity() {
        return this.poolResizeQuantity;
    }

    public void setPoolResizeQuantity(String poolResizeQuantity) {
        this.poolResizeQuantity = poolResizeQuantity;
    }

    public String getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public void setIdleTimeoutInSeconds(String idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds = idleTimeoutInSeconds;
    }

    public boolean isFailAllConnections() {
        return this.failAllConnections;
    }

    public void setFailAllConnections(boolean failAllConnections) {
        this.failAllConnections = failAllConnections;
    }

    public boolean matchConnections() {
        return this.matchConnections;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections = matchConnections;
    }

    public int getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(int transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public void setConnectionValidationRequired(boolean validation) {
        this.isConnectionValidationRequired = validation;
    }

    public boolean isIsConnectionValidationRequired() {
        return this.isConnectionValidationRequired;
    }

    public boolean isLazyConnectionAssoc() {
        return this.lazyConnectionAssoc;
    }

    public void setLazyConnectionAssoc(boolean enabled) {
        this.lazyConnectionAssoc = enabled;
    }

    public boolean isLazyConnectionEnlist() {
        return this.lazyConnectionEnlist;
    }

    public void setLazyConnectionEnlist(boolean enabled) {
        this.lazyConnectionEnlist = enabled;
    }

    public boolean isAssociateWithThread() {
        return this.associateWithThread;
    }

    public void setAssociateWithThread(boolean enabled) {
        this.associateWithThread = enabled;
    }

    public boolean isNonTransactional() {
        return this.nonTransactional;
    }

    public void setNonTransactional(boolean enabled) {
        this.nonTransactional = enabled;
    }

    public boolean isNonComponent() {
        return this.nonComponent;
    }

    public void setNonComponent(boolean enabled) {
        this.nonComponent = enabled;
    }

    public String getConnectionLeakTracingTimeout() {
        return this.connectionLeakTracingTimeout;
    }

    public void setConnectionLeakTracingTimeout(String timeout) {
        this.connectionLeakTracingTimeout = timeout;
    }

    public void setSecurityMaps(ConnectorSecurityMap[] securityMapArray) {
        this.securityMaps = securityMapArray;
    }

    public ConnectorSecurityMap[] getSecurityMaps() {
        return this.securityMaps;
    }

    public boolean isValidateAtmostEveryIdleSecs() {
        return this.validateAtmostEveryIdleSecs;
    }

    public void setValidateAtmostEveryIdleSecs(boolean enabled) {
        this.validateAtmostEveryIdleSecs = enabled;
    }

    public void setMaxConnectionUsage(String count) {
        this.maxConnectionUsage = count;
    }

    public String getMaxConnectionUsage() {
        return this.maxConnectionUsage;
    }

    public String getConCreationRetryInterval() {
        return this.conCreationRetryInterval;
    }

    public void setConCreationRetryInterval(String retryInterval) {
        this.conCreationRetryInterval = retryInterval;
    }

    public String getConCreationRetryAttempts() {
        return this.conCreationRetryAttempts;
    }

    public void setConCreationRetryAttempts(String retryAttempts) {
        this.conCreationRetryAttempts = retryAttempts;
    }

    public String getValidateAtmostOncePeriod() {
        return this.validateAtmostOncePeriod;
    }

    public void setValidateAtmostOncePeriod(String validateAtmostOncePeriod) {
        this.validateAtmostOncePeriod = validateAtmostOncePeriod;
    }

    public boolean isConnectionReclaim() {
        return this.connectionReclaim;
    }

    public void setConnectionReclaim(boolean connectionReclaim) {
        this.connectionReclaim = connectionReclaim;
    }

    public String toString() {
        String returnVal = "";
        StringBuffer sb = new StringBuffer("ConnectorConnectionPool :: ");
        try {
            sb.append(this.getName());
            sb.append("\nsteady size: ");
            sb.append(this.getSteadyPoolSize());
            sb.append("\nmax pool size: ");
            sb.append(this.getMaxPoolSize());
            sb.append("\nmax wait time: ");
            sb.append(this.getMaxWaitTimeInMillis());
            sb.append("\npool resize qty: ");
            sb.append(this.getPoolResizeQuantity());
            sb.append("\nIdle timeout: ");
            sb.append(this.getIdleTimeoutInSeconds());
            sb.append("\nfailAllConnections: ");
            sb.append(this.isFailAllConnections());
            sb.append("\nTransaction Support Level: ");
            sb.append(this.transactionSupport);
            sb.append("\nisConnectionValidationRequired ");
            sb.append(this.isConnectionValidationRequired);
            sb.append("\npreferValidateOverRecreate ");
            sb.append(this.preferValidateOverRecreate);
            sb.append("\nmatchConnections ");
            sb.append(this.matchConnections);
            sb.append("\nassociateWithThread ");
            sb.append(this.associateWithThread);
            sb.append("\nlazyConnectionAssoc ");
            sb.append(this.lazyConnectionAssoc);
            sb.append("\nlazyConnectionEnlist ");
            sb.append(this.lazyConnectionEnlist);
            sb.append("\nmaxConnectionUsage ");
            sb.append(this.maxConnectionUsage);
            sb.append("\npingPoolDuringCreation ");
            sb.append(this.pingDuringPoolCreation);
            sb.append("\npoolingOn ");
            sb.append(this.poolingOn);
            sb.append("\nvalidateAtmostOncePeriod ");
            sb.append(this.validateAtmostOncePeriod);
            sb.append("\nconnectionLeakTracingTimeout");
            sb.append(this.connectionLeakTracingTimeout);
            sb.append("\nconnectionReclaim");
            sb.append(this.connectionReclaim);
            sb.append("\nconnectionCreationRetryAttempts");
            sb.append(this.conCreationRetryAttempts);
            sb.append("\nconnectionCreationRetryIntervalInMilliSeconds");
            sb.append(this.conCreationRetryInterval);
            sb.append("\nnonTransactional ");
            sb.append(this.nonTransactional);
            sb.append("\nnonComponent ");
            sb.append(this.nonComponent);
            sb.append("\nConnectorDescriptorInfo -> ");
            sb.append("\nrarName: ");
            if (this.connectorDescriptorInfo != null) {
                sb.append(this.connectorDescriptorInfo.getRarName());
                sb.append("\nresource adapter class: ");
                sb.append(this.connectorDescriptorInfo.getResourceAdapterClassName());
                sb.append("\nconnection def name: ");
                sb.append(this.connectorDescriptorInfo.getConnectionDefinitionName());
                sb.append("\nMCF Config properties-> ");
                for (Object e : this.connectorDescriptorInfo.getMCFConfigProperties()) {
                    ConnectorConfigProperty ep = (ConnectorConfigProperty)e;
                    sb.append(ep.getName());
                    sb.append(":");
                    sb.append("password".equalsIgnoreCase(ep.getName()) ? "****" : ep.getValue());
                    sb.append("\n");
                }
            }
            if (this.securityMaps != null) {
                sb.append("SecurityMaps -> {");
                for (ConnectorSecurityMap securityMap : this.securityMaps) {
                    if (securityMap == null || securityMap.getName() == null) continue;
                    sb.append(securityMap.getName());
                    sb.append(" ");
                }
                sb.append("}");
            }
            returnVal = sb.toString();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception while computing toString() of connection pool [ " + String.valueOf(this.name) + " ]", e);
        }
        return returnVal;
    }

    public boolean isPartitionedPool() {
        return this.partitionedPool;
    }

    public void setPartitionedPool(boolean partitionedPool) {
        this.partitionedPool = partitionedPool;
    }

    public String getPoolDataStructureType() {
        return this.poolDataStructureType;
    }

    public void setPoolDataStructureType(String poolDataStructureType) {
        this.poolDataStructureType = poolDataStructureType;
    }

    public String getPoolWaitQueue() {
        return this.poolWaitQueue;
    }

    public void setPoolWaitQueue(String poolWaitQueue) {
        this.poolWaitQueue = poolWaitQueue;
    }

    public String getDataStructureParameters() {
        return this.dataStructureParameters;
    }

    public void setDataStructureParameters(String dataStructureParameters) {
        this.dataStructureParameters = dataStructureParameters;
    }

    public String getResourceGatewayClass() {
        return this.resourceGatewayClass;
    }

    public void setResourceGatewayClass(String resourceGatewayClass) {
        this.resourceGatewayClass = resourceGatewayClass;
    }

    public boolean isPreferValidateOverRecreate() {
        return this.preferValidateOverRecreate;
    }

    public void setPreferValidateOverRecreate(boolean preferValidateOverRecreate) {
        this.preferValidateOverRecreate = preferValidateOverRecreate;
    }

    public long getDynamicReconfigWaitTimeout() {
        return this.dynamicReconfigWaitTimeout;
    }

    public void setDynamicReconfigWaitTimeout(long dynamicReconfigWaitTimeout) {
        this.dynamicReconfigWaitTimeout = dynamicReconfigWaitTimeout;
    }

    public PoolInfo getPoolInfo() {
        return new PoolInfo(this.name, this.applicationName, this.moduleName);
    }
}

