/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.frametypes;

import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.grizzly.websockets.BaseFrameType;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.Utf8Utils;
import org.glassfish.grizzly.websockets.WebSocket;

public class TextFrameType
extends BaseFrameType {
    @Override
    public void setPayload(DataFrame frame, byte[] data) {
        frame.setPayload(data);
    }

    @Override
    public byte[] getBytes(DataFrame dataFrame) {
        byte[] bytes = dataFrame.getBytes();
        if (bytes == null) {
            this.setPayload(dataFrame, Utf8Utils.encode(Charsets.UTF8_CHARSET, dataFrame.getTextPayload()));
        }
        return dataFrame.getBytes();
    }

    @Override
    public void respond(WebSocket socket, DataFrame frame) {
        if (frame.isLast()) {
            socket.onMessage(frame.getTextPayload());
        } else {
            socket.onFragment(frame.isLast(), frame.getTextPayload());
        }
    }
}

