/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.DistributedStateCache;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryTargetSelector {
    static final String CORETYPE = GroupManagementService.MemberType.CORE.toString();
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    static final RecoverySelectorMode DEFAULT_MODE = RecoverySelectorMode.SIMPLESELECT;

    private RecoveryTargetSelector() {
    }

    public static boolean resolveRecoveryTarget(RecoverySelectorMode mode, List<GMSMember> members, String failedMemberToken, GMSContext ctx) {
        boolean recoveryServer = false;
        String groupName = ctx.getGroupName();
        if (mode == null) {
            mode = DEFAULT_MODE;
        }
        switch (mode) {
            case SIMPLESELECT: {
                recoveryServer = RecoveryTargetSelector.resolveWithSimpleSelectionAlgorithm(members, failedMemberToken, groupName);
                break;
            }
            case FIRSTLIVESELECT: {
                recoveryServer = RecoveryTargetSelector.resolveWithEasySelectionAlgorithm(members, failedMemberToken, groupName);
                break;
            }
            case HOSTSELECT: {
                recoveryServer = RecoveryTargetSelector.resolveWithHostSelectionAlgorithm(members, failedMemberToken, groupName);
                break;
            }
            default: {
                logger.log(Level.WARNING, "recovery.selector.invalid.mode", new Object[]{mode.toString(), failedMemberToken, groupName});
            }
        }
        return recoveryServer;
    }

    private static boolean resolveWithHostSelectionAlgorithm(List<GMSMember> members, String failedMember, String groupName) {
        return false;
    }

    private static boolean resolveWithSimpleSelectionAlgorithm(List<GMSMember> viewCache, String failedMember, String groupName) {
        boolean recover = false;
        String recoverer = null;
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        String self = ctx.getServerIdentityToken();
        List<String> liveCache = RecoveryTargetSelector.getMemberTokens(viewCache, ctx.getSuspectList(), ctx.getGroupHandle().getAllCurrentMembers());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "LiveCache = " + liveCache);
        }
        List<String> vCache = RecoveryTargetSelector.getCoreMembers(viewCache);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "vCache = " + vCache);
        }
        block0: for (int i = 0; i < vCache.size(); ++i) {
            if (!vCache.get(i).equals(failedMember)) continue;
            if (i == vCache.size() - 1) {
                String member = vCache.get(0);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Failed Member was last member of the previous view, The first live core member will be selected as recoverer");
                    logger.log(Level.FINEST, "First Core Member is " + member);
                    logger.log(Level.FINEST, "Live members are :" + liveCache.toString());
                }
                if (!liveCache.contains(member)) continue;
                recoverer = member;
                continue;
            }
            List<String> subset = vCache.subList(i + 1, vCache.size());
            for (String mem : subset) {
                if (!liveCache.contains(mem)) continue;
                recoverer = mem;
                continue block0;
            }
        }
        if (recoverer == null) {
            logger.log(Level.WARNING, "recovery.selector.failed", new Object[]{failedMember, RecoveryTargetSelector.getMemberTokens(viewCache)});
            for (String coreMember : vCache) {
                if (!liveCache.contains(coreMember)) continue;
                recoverer = coreMember;
                break;
            }
        }
        if (recoverer != null) {
            if (recoverer.equals(self)) {
                recover = true;
            }
            RecoveryTargetSelector.setRecoverySelectionState(recoverer, failedMember, groupName);
        }
        return recover;
    }

    private static boolean resolveWithEasySelectionAlgorithm(List<GMSMember> oldViewCache, String failedMember, String groupName) {
        boolean recover = false;
        String recoverer = null;
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        String self = ctx.getServerIdentityToken();
        List<String> liveCache = RecoveryTargetSelector.getMemberTokens(oldViewCache, ctx.getSuspectList(), ctx.getGroupHandle().getAllCurrentMembers());
        logger.log(Level.FINE, "LiveCache = " + liveCache);
        List<String> coreCache = RecoveryTargetSelector.getCoreMembers(oldViewCache);
        logger.log(Level.FINE, "CoreCache = " + coreCache);
        for (String coreMember : coreCache) {
            if (!liveCache.contains(coreMember)) continue;
            recoverer = coreMember;
            break;
        }
        if (recoverer != null) {
            if (recoverer.equals(self)) {
                recover = true;
            }
            RecoveryTargetSelector.setRecoverySelectionState(recoverer, failedMember, groupName);
        }
        return recover;
    }

    private static List<String> getCoreMembers(List<GMSMember> viewCache) {
        ArrayList<String> temp = new ArrayList<String>();
        for (GMSMember member : viewCache) {
            if (!member.getMemberType().equals(CORETYPE)) continue;
            temp.add(member.getMemberToken());
        }
        return temp;
    }

    private static void dWait(long damperWaitOnMultiFails) {
        try {
            Thread.sleep(damperWaitOnMultiFails);
        }
        catch (InterruptedException e) {
            logger.log(Level.FINEST, e.getLocalizedMessage(), e);
        }
    }

    public static void setRecoverySelectionState(String recovererMemberToken, String failedMemberToken, String groupName) {
        logger.log(Level.INFO, "recovery.selector.appointed", new Object[]{recovererMemberToken, failedMemberToken, groupName});
        GMSContext ctx = GMSContextFactory.getGMSContext(groupName);
        if (ctx.isWatchdog()) {
            return;
        }
        DistributedStateCache dsc = ctx.getDistributedStateCache();
        Hashtable<String, FailureRecoveryActionFactory> reg = ctx.getRouter().getFailureRecoveryAFRegistrations();
        for (String component : reg.keySet()) {
            try {
                dsc.addToCache(component, recovererMemberToken, (Serializable)((Object)failedMemberToken), (Serializable)((Object)RecoveryTargetSelector.setStateAndTime()));
            }
            catch (GMSException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
    }

    private static String setStateAndTime() {
        return GroupManagementService.RECOVERY_STATE.RECOVERY_SERVER_APPOINTED.toString() + "|" + System.currentTimeMillis();
    }

    private static List<String> getMemberTokens(List<GMSMember> members, List<String> exclusionList, List<String> currentMembers) {
        ArrayList<String> temp = new ArrayList<String>();
        for (GMSMember member : members) {
            String token = member.getMemberToken();
            if (!member.getMemberType().equals(CORETYPE) || !currentMembers.contains(token) || exclusionList.contains(token)) continue;
            temp.add(token);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "SuspectedMembers: " + exclusionList.toString());
            logger.log(Level.FINEST, "LiveMembers: " + ((Object)temp).toString());
        }
        return temp;
    }

    private static String getMemberTokens(List<GMSMember> members) {
        StringBuilder temp = new StringBuilder();
        for (GMSMember member : members) {
            if (!member.getMemberType().equals(CORETYPE)) continue;
            temp.append(member.getMemberToken()).append(":");
        }
        return temp.toString();
    }

    public static enum RecoverySelectorMode {
        SIMPLESELECT,
        HOSTSELECT,
        FIRSTLIVESELECT;

    }
}

