/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common.tasks;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RunnableTask
implements Runnable {
    private static final TestLogger log = TestLogger.get(RunnableTask.class);
    private final String jndiName;
    private final String expectedJndiValue;
    private final String contexualClassName;
    private final long blockTime;
    private volatile int count = 0;

    @Override
    public void run() {
        if (this.blockTime > 0L) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.blockTime);
            }
            catch (InterruptedException e) {
                log.severe("", e);
            }
        }
        boolean jndiPassed = this.lookupEnvRef();
        boolean loadClassPassed = this.loadClass();
        if (!jndiPassed || !loadClassPassed) {
            throw new RuntimeException("jndi test passed: " + jndiPassed + ", class loading test passed: " + loadClassPassed);
        }
        ++this.count;
    }

    public RunnableTask(String jndiName, String jndiValue, String className, long blockTime) {
        this.contexualClassName = className;
        this.jndiName = jndiName;
        this.expectedJndiValue = jndiValue;
        this.blockTime = blockTime;
    }

    public RunnableTask(String jndiName, String jndiValue, String className) {
        this.contexualClassName = className;
        this.jndiName = jndiName;
        this.expectedJndiValue = jndiValue;
        this.blockTime = 0L;
    }

    protected boolean lookupEnvRef() {
        boolean passed = false;
        String value = null;
        try {
            value = (String)InitialContext.doLookup(this.jndiName);
            if (this.expectedJndiValue.equals(value)) {
                passed = true;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return passed;
    }

    public int getCount() {
        return this.count;
    }

    protected boolean loadClass() {
        boolean passed = false;
        try {
            Class<?> loadedClass = Thread.currentThread().getContextClassLoader().loadClass(this.contexualClassName);
            if (this.contexualClassName == loadedClass.getName()) {
                passed = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return passed;
    }
}

