/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.spi.editor.controls.Helper;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;

public final class ControlGenerator {
    private ControlGenerator() {
    }

    public static void addControls(EClass rootClass, VElement compositeToFill, Set<EStructuralFeature> features) {
        ControlGenerator.addControls(rootClass, compositeToFill, features, ToolingModeUtil.isSegmentToolingEnabled());
    }

    static void addControls(EClass rootClass, VElement compositeToFill, Set<EStructuralFeature> features, boolean segmentTooling) {
        if (!VContainer.class.isInstance(compositeToFill) && !VView.class.isInstance(compositeToFill)) {
            return;
        }
        HashMap<EClass, EReference> childParentReferenceMap = new HashMap<EClass, EReference>();
        Helper.getReferenceMap(rootClass, childParentReferenceMap);
        for (EStructuralFeature feature : features) {
            VControl control = VViewFactory.eINSTANCE.createControl();
            control.setName("Control " + feature.getName());
            control.setReadonly(false);
            List<EReference> bottomUpPath = Helper.getReferencePath(rootClass, feature.getEContainingClass(), childParentReferenceMap);
            VDomainModelReference modelReference = segmentTooling ? ControlGenerator.createSegmentDmr(feature, bottomUpPath) : ControlGenerator.createLegacyDmr(feature, bottomUpPath);
            control.setDomainModelReference(modelReference);
            if (VContainer.class.isInstance(compositeToFill)) {
                ((VContainer)compositeToFill).getChildren().add((Object)control);
                continue;
            }
            if (!VView.class.isInstance(compositeToFill)) continue;
            ((VView)compositeToFill).getChildren().add((Object)control);
        }
    }

    private static VDomainModelReference createLegacyDmr(EStructuralFeature domainFeature, List<EReference> bottomUpPath) {
        VFeaturePathDomainModelReference dmr = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
        dmr.getDomainModelEReferencePath().addAll(bottomUpPath);
        dmr.setDomainModelEFeature(domainFeature);
        return dmr;
    }

    private static VDomainModelReference createSegmentDmr(EStructuralFeature domainFeature, List<EReference> bottomUpPath) {
        VDomainModelReference dmr = VViewFactory.eINSTANCE.createDomainModelReference();
        bottomUpPath.stream().map(ENamedElement::getName).map(ControlGenerator::createFeatureSegment).forEach(arg_0 -> dmr.getSegments().add(arg_0));
        dmr.getSegments().add((Object)ControlGenerator.createFeatureSegment(domainFeature.getName()));
        return dmr;
    }

    private static VDomainModelReferenceSegment createFeatureSegment(String featureName) {
        VFeatureDomainModelReferenceSegment segment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
        segment.setDomainModelFeature(featureName);
        return segment;
    }

    public static void generateAllControls(VView view) {
        URI uri = EcoreUtil.getURI((EObject)view);
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.editor.controls", e.getMessage(), (Throwable)e));
        }
        int rsSize = resSet.getResources().size();
        EcoreUtil.resolveAll((ResourceSet)resSet);
        while (rsSize != resSet.getResources().size()) {
            EcoreUtil.resolveAll((ResourceSet)resSet);
            rsSize = resSet.getResources().size();
        }
        VView vview = (VView)resource.getContents().get(0);
        EClass rootEClass = vview.getRootEClass();
        LinkedHashSet<EStructuralFeature> mySet = new LinkedHashSet<EStructuralFeature>((Collection<EStructuralFeature>)rootEClass.getEAllStructuralFeatures());
        ControlGenerator.addControls(rootEClass, (VElement)((VView)resource.getContents().get(0)), mySet);
        try {
            resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.ecp.view.editor.controls", e.getMessage(), (Throwable)e));
        }
    }
}

